/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef CHECKTREEVIEW_H_
#define CHECKTREEVIEW_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <ace/config.h>
#include <wx/treectrl.h>
#include <wx/imaglist.h>
#include <wx/event.h>


class CheckTreeView : public wxTreeCtrl
{
public:
	enum CheckState {
		CB_NONE = 0, CB_UNCHECKED = 1,
		CB_CHECKED = 2, CB_MIXED = 3
	};
	
	CheckTreeView(wxWindow* parent, wxWindowID id,
		const wxPoint& pos = wxDefaultPosition,
		const wxSize& size = wxDefaultSize,
		long style = wxTR_DEFAULT_STYLE,
		const wxValidator& validator = wxDefaultValidator,
		const wxString& name = wxTreeCtrlNameStr);
	
	virtual ~CheckTreeView();
	
	CheckState GetCheckState(wxTreeItemId const& item) const;

	void SetCheckState(wxTreeItemId const& item, CheckState state);
private:
	void onStateImageClick(wxTreeEvent& evt);
	
	void onKeyDown(wxTreeEvent& evt);
	
	void toggleCheckState(wxTreeItemId const& item);
	
	void doSetCheckState(
		wxTreeItemId const& item,
		CheckState new_state, bool by_user);
	
	wxImageList m_imageList;
	
	DECLARE_EVENT_TABLE()
};

inline void
CheckTreeView::SetCheckState(wxTreeItemId const& item, CheckState state)
{
	doSetCheckState(item, state, false);
}


class CheckTreeEvent : public wxNotifyEvent
{
public:
	typedef void (wxEvtHandler::*Function)(CheckTreeEvent&);
	typedef CheckTreeView::CheckState CheckState;
	
	CheckTreeEvent(
		wxEventType event, int id, wxTreeItemId const& item,
		CheckState old_state, CheckState new_state,
		bool is_action_by_user);

	virtual wxEvent* Clone() const;
	
	wxTreeItemId const& getItem() const { return m_item; }
	
	CheckState getOldState() const { return m_oldState; }
	
	CheckState getNewState() const { return m_newState; }
	
	bool isActionByUser() const { return m_isActionByUser; }
private:
	wxTreeItemId m_item;
	CheckState m_oldState;
	CheckState m_newState;
	bool m_isActionByUser;
};


DECLARE_LOCAL_EVENT_TYPE(myEVT_TREE_CHECK_STATE_CHANGING, 0)
DECLARE_LOCAL_EVENT_TYPE(myEVT_TREE_CHECK_STATE_CHANGED, 1)

#define EVT_TREE_CHECK_STATE_CHANGING(id, fn) \
DECLARE_EVENT_TABLE_ENTRY(myEVT_TREE_CHECK_STATE_CHANGING, id, wxID_ANY, \
(wxObjectEventFunction) (wxEventFunction) \
wxStaticCastEvent(CheckTreeEvent::Function, & fn), \
(wxObject *)0),

#define EVT_TREE_CHECK_STATE_CHANGED(id, fn) \
DECLARE_EVENT_TABLE_ENTRY(myEVT_TREE_CHECK_STATE_CHANGED, id, wxID_ANY, \
(wxObjectEventFunction) (wxEventFunction) \
wxStaticCastEvent(CheckTreeEvent::Function, & fn), \
(wxObject *)0),

#endif
