/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "StatusDocklet.h"
#include "eggtrayicon.h"
#include <gdk/gdkproperty.h>
#include <gdk/gdkwindow.h>
#include <X11/Xatom.h>

using namespace std;

class StatusDocklet::XEmbedWindow : public Gtk::Window
{
public:
	XEmbedWindow() : Gtk::Window(GTK_WINDOW(egg_tray_icon_new(""))) {}
};


StatusDocklet::StatusDocklet()
{
	m_ptrWindow = createStatusDocklet();
}

StatusDocklet::~StatusDocklet()
{
}

bool
StatusDocklet::onDelete(GdkEventAny* evt)
{
	m_ptrWindow.reset();
	m_ptrWindow = createStatusDocklet();
	return true;
}

std::auto_ptr<Gtk::Window>
StatusDocklet::createStatusDocklet()
{
	auto_ptr<Gtk::Window> wnd(new XEmbedWindow);
	gtk_widget_realize(GTK_WIDGET(wnd->gobj()));
	if (EGG_TRAY_ICON(wnd->gobj())->manager_window) {
		/*
		There is a bug in certain KDE versions that causes the removal
		of our docklet when another icon is removed. The workaround is
		catching the delete event and recreating the docklet.
		*/
		wnd->signal_delete_event().connect(
			sigc::mem_fun(*this, &StatusDocklet::onDelete)
		);
	} else {
		wnd.reset(new Gtk::Window);
		wnd->resize(22, 22);
		gtk_widget_realize(GTK_WIDGET(wnd->gobj()));
		GdkWindow *window = GTK_WIDGET(wnd->gobj())->window;
		glong data[1];
		data[0] = 0;
		GdkAtom atom = gdk_atom_intern("_KDE_NET_WM_SYSTEM_TRAY_WINDOW_FOR", FALSE);
		gdk_property_change(
			window, atom, (GdkAtom)XA_WINDOW, 32,
			GDK_PROP_MODE_REPLACE, (guchar *)&data, 1
		);
	}
	
	return wnd;
}
