/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef DEBUGLAYOUT_H_
#define DEBUGLAYOUT_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AbstractDebugAgent.h"
#include "IntrusivePtr.h"
#include <ace/OS_NS_Thread.h>
#include <gtkmm/layout.h>
#include <string>
#include <deque>
#include <map>
#include <stddef.h>

class BString;
class SplittableBuffer;
class DebugConnection;

class DebugLayout : public Gtk::Layout
{
public:
	typedef AbstractDebugAgent::TrafficDirection TrafficDirection;
	typedef AbstractDebugAgent::HttpMessageType HttpMessageType;
	
	enum {
		LAYOUT_PADDING = 10,
		MSG_SEL_BORDER_WIDTH = 1,
		MSG_SEL_SPACING = 1,
		MSG_MAIN_BORDER_OFFSET = MSG_SEL_BORDER_WIDTH + MSG_SEL_SPACING,
		MSG_MAIN_BORDER_WIDTH = 2,
		MSG_INNER_WIDTH = 8,
		MSG_INITIAL_INNER_HEIGHT = 12,
		MSG_OUTER_WIDTH = MSG_INNER_WIDTH + MSG_MAIN_BORDER_OFFSET*2,
		MSG_INITIAL_OUTER_HEIGHT = MSG_INITIAL_INNER_HEIGHT +
			MSG_MAIN_BORDER_OFFSET*2,
		MSG_HOR_SPACING = 1,
		MSG_VER_SPACING = 3,
		MSG_SHIFT = 4,
		CONN_BORDER = 2,
		CONN_PADDING = 6,
		CONN_WIDTH = MSG_OUTER_WIDTH*5 + MSG_HOR_SPACING*4 +
			CONN_PADDING*2 + CONN_BORDER*2,
		CONN_INITIAL_HEIGHT = CONN_BORDER + CONN_PADDING,
		CONN_HOR_SPACING = 12,
		CONN_VER_SPACING = 10
	};
	
	DebugLayout();
	
	virtual ~DebugLayout();
	
	int getWidth() const { return m_width; }
	
	int getHeight() const { return m_height; }
	
	int getNextObjectBeginPos() const { return m_nextObjectBeginPos; }
	
	void setNextObjectBeginPos(int pos) { m_nextObjectBeginPos = pos; }
	
	int getNextObjectEndPos() const { return m_nextObjectEndPos; }
	
	void setNextObjectEndPos(int pos) { m_nextObjectEndPos = pos; }
	
	int getConnectionsToTrack() const { return m_connectionsToTrack; }
	
	void setConnectionsToTrack(int val) { m_connectionsToTrack = val; }
	
	size_t getTrafficLimit() const { return m_trafficLimit; }
	
	void setTrafficLimit(size_t val) { m_trafficLimit = val; }
	
	void growBy(int increment);
	
	DebugConnection* findOpenConnection(ACE_thread_t thread_id);
	
	void clientConnectionBegin(ACE_thread_t thread_id);
	
	void clientConnectionEnd(ACE_thread_t thread_id);
	
	void httpMessageBegin(
		ACE_thread_t thread_id, int request_id,
		HttpMessageType type, std::string const& headers);
	
	void httpMessageEnd(ACE_thread_t thread_id,
		HttpMessageType type, bool error);
	
	void logMessage(ACE_thread_t thread_id, std::string const& msg);
	
	void logTraffic(ACE_thread_t thread_id,
		SplittableBuffer& traf, TrafficDirection dir);
private:
	class Column;
	typedef std::map<ACE_thread_t, DebugConnection*> ConnectionMap;
	typedef std::deque<IntrusivePtr<DebugConnection> > ConnectionQueue;
	typedef std::deque<IntrusivePtr<Column> > ColumnQueue;
	
	void removeOldConnections(int num2keep);
	
	void adjustColumns();
	
	void onDestroyConnection(
		DebugConnection* conn, ConnectionMap::iterator const& map_pos);
	
	int m_width;
	int m_height;
	int m_nextObjectBeginPos;
	int m_nextObjectEndPos;
	int m_connectionsToTrack;
	size_t m_trafficLimit;
	ColumnQueue m_columns;
	ConnectionMap m_openConnections;
	ConnectionQueue m_orderedConnections;
};

#endif
