/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef DEBUGCONNECTION_H_
#define DEBUGCONNECTION_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AbstractDebugAgent.h"
#include "RefCountable.h"
#include "RefCounter.h"
#include "IntrusivePtr.h"
#include <ace/OS_NS_Thread.h>
#include <sigc++/sigc++.h>
#include <gtkmm/eventbox.h>
#include <gtkmm/fixed.h>
#include <gtkmm/drawingarea.h>
#include <glibmm/refptr.h>
#include <string>
#include <map>

class DebugLayout;
class DebugMessage;
class ClientRequestDescriptor;
class SplittableBuffer;
namespace Gtk {
	class TextBuffer;
}

class DebugConnection :
	public Gtk::EventBox,
	public RefCountable<RefCounter<ACE_NULL_SYNCH> >
{
public:
	typedef AbstractDebugAgent::TrafficDirection TrafficDirection;
	typedef AbstractDebugAgent::HttpMessageType HttpMessageType;
	
	DebugConnection(DebugLayout& layout, int top, int left, int right);
	
	virtual ~DebugConnection();
	
	int getTop() const { return m_top; }
	
	void setTop(int top) { m_top = top; }
	
	int getLeft() const { return m_left; }
	
	int getRight() const { return m_right; }
	
	int getHeight() const { return m_height; }
	
	int getBottom() const { return m_top + m_height; }
	
	bool isClosed() const { return m_isClosed; }
	
	void growBy(int increment);
	
	void finish(bool error = false);
	
	void showMessagesInRange(int top, int bottom);
	
	void addClientRequestDescriptor(
		int id, IntrusivePtr<ClientRequestDescriptor> const& desc);
	
	void httpMessageBegin(int request_id,
		HttpMessageType type, std::string const& headers);
	
	void httpMessageEnd(HttpMessageType type, bool error);
	
	void logMessage(std::string const& msg);
	
	void logTraffic(SplittableBuffer& traf, TrafficDirection dir);
	
	sigc::signal<void>& destroySignal() { return m_destroySignal; }
private:
	class Traffic;
	class Channel;
	class ViewWindow;
	class TrafficPage;
	class SaveTrafficDialog;
	
	enum {
		INCOMING_REQUEST_CHANNEL = 0,
		OUTGOING_REQUEST_CHANNEL,
		INCOMING_RESPONSE_CHANNEL,
		SCRIPT_CHANNEL,
		OUTGOING_RESPONSE_CHANNEL,
		NUM_CHANNELS
	};
	
	typedef std::map<int, IntrusivePtr<ClientRequestDescriptor> > RequestMap;
	typedef sigc::slot<ViewWindow*> ViewWindowAccessor;
	
	static int getChannelFor(HttpMessageType msg_type);
	
	static int getChannelFor(TrafficDirection traf_dir);
	
	bool onButtonPress(GdkEventButton* event);
	
	void createViewWindow();
	
	IntrusivePtr<ClientRequestDescriptor> getClientRequestDescriptor(int id) const;
	
	DebugLayout& m_rLayout;
	int m_top;
	int m_left;
	int m_right;
	int m_height;
	bool m_isClosed;
	IntrusivePtr<Channel> m_channels[NUM_CHANNELS];
	Gtk::Fixed m_container;
	Gtk::DrawingArea m_borders[4];
	Glib::RefPtr<Gtk::TextBuffer> m_ptrDebugText;
	RequestMap m_requestMap;
	ViewWindowAccessor m_viewWindowAccessor;
	sigc::signal<void> m_destroySignal;
};

#endif
