/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef BASICCONFIGDIALOG_H_
#define BASICCONFIGDIALOG_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtkmm/window.h>

class Config;
namespace Glib {
	class ustring;
}
namespace Gtk {
	class Entry;
	class CheckButton;
}

class BasicConfigDialog : public Gtk::Window
{
private:
	BasicConfigDialog();
public:
	virtual ~BasicConfigDialog();
	
	static void showWindow();
private:
	virtual void on_hide();
	
	void loadConfig();
	
	void onApply();
	
	bool restoreOldConfig(Config const& config);
	
	void showError(Glib::ustring const& msg);
	
	void showWarning(Glib::ustring const& msg);
	
	static BasicConfigDialog* m_spInstance;
	Gtk::Entry* m_pListenPort;
	Gtk::CheckButton* m_pTrayAnimation;
	Gtk::CheckButton* m_pForward;
	Gtk::Entry* m_pProxyHost;
	Gtk::Entry* m_pProxyPort;
};

#endif
