/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef URLPATTERNSFILE_H_
#define URLPATTERNSFILE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "BString.h"
#include <string>
#include <iosfwd>
#include <list>

class SplittableBuffer;
class UrlPatterns;
class ConfErrorHandler;

class UrlPatternsFile
{
public:
	void clear();
	
	void load(std::string const& text, UrlPatterns& target, ConfErrorHandler& eh);
	
	void swap(UrlPatternsFile& other);
private:
	class Loader;
	
	class Element
	{
	public:
		enum Type { BLANK_LINE, COMMENT, PATTERN };
		enum TagType {
			NULL_TAG, TAG_FORBID, TAG_ALLOW,
			TAG_SUBST_HTML, TAG_SUBST_IMAGE,
			TAG_SUBST_FLASH, TAG_SUBST_JS,
			TAG_POSITIVE_HINT, TAG_NEGATIVE_HINT
		};
		
		explicit Element()
		: m_type(BLANK_LINE), m_tagType(NULL_TAG) {}
		
		explicit Element(BString const& comment)
		: m_type(COMMENT), m_tagType(NULL_TAG), m_pattern(comment) {}
		
		Element(TagType ttype, BString const& tag, BString const& pattern)
		: m_type(PATTERN), m_tagType(ttype), m_tag(tag), m_pattern(pattern) {}
		
		Type getType() const { return m_type; }
		
		BString const& getComment() const { return m_pattern; }
		
		BString const& getTag() const { return m_tag; }
		
		BString const& getPattern() const { return m_pattern; }
	private:
		Type m_type;
		TagType m_tagType;
		BString m_tag;
		BString m_pattern; // or comment
	};
	
	std::list<Element> m_elements;
};


inline void swap(UrlPatternsFile& o1, UrlPatternsFile& o2)
{
	o1.swap(o2);
}

#endif
