/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef COMBINEDURLPATTERNS_H_
#define COMBINEDURLPATTERNS_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UrlPatterns.h"

class URI;

class CombinedUrlPatterns
{
public:
	CombinedUrlPatterns() {}
	
	~CombinedUrlPatterns() {}
	
	// member-wise copying is OK
	
	UrlPatterns& standardPatterns() { return m_standardPatterns; }
	
	UrlPatterns const& standardPatterns() const { return m_standardPatterns; }
	
	UrlPatterns& localPatterns() { return m_localPatterns; }
	
	UrlPatterns const& localPatterns() const { return m_localPatterns; }
	
	bool isForbidden(URI const& url) const;
	
	UrlPatterns::Substitution getSubstitutionFor(URI const& url) const;
	
	int getHintFor(URI const& url) const;
private:
	UrlPatterns m_standardPatterns;
	UrlPatterns m_localPatterns;
};

#endif
