/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef TIMER_H_
#define TIMER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include "Reactor.h"
#include "EventHandler.h"
#include <ace/Time_Value.h>
#include <sigc++/sigc++.h>

class Timer : private EventHandlerBase
{
	DECLARE_NON_COPYABLE(Timer)
public:
	// The initial state is inactive.
	Timer(Reactor& reactor,
		sigc::slot<void> const& callback,
		ACE_Time_Value const& delay);
	
	~Timer();
	
	bool isActive() const { return m_isActive; }
	
	void deactivate();
	
	void reactivate();
	
	void postpone() { if (m_isActive) reactivate(); }
	
	void ensureActive() { if (!m_isActive) reactivate(); }
private:
	virtual void handleTimeout(ReactorTimerId const&);
	
	virtual void ref();
	
	virtual bool unref();
	
	Reactor* m_pReactor;
	int m_refCounter; // must come before m_id
	ReactorTimerId m_id;
	sigc::slot<void> m_callback;
	ACE_Time_Value m_delay;
	bool m_isActive;
};

#endif
