/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef NETWORKACTIVITYREPORTER_H_
#define NETWORKACTIVITYREPORTER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <ace/Synch.h>
#include <ace/Time_Value.h>

class AbstractNetworkActivityHandler;

class NetworkActivityReporter
{
private:
	NetworkActivityReporter();

	~NetworkActivityReporter();
	
	NetworkActivityReporter(NetworkActivityReporter const&);
	
	NetworkActivityReporter& operator=(NetworkActivityReporter const&);
public:	
	void reportActivity();
	
	static NetworkActivityReporter* instance();

	static AbstractNetworkActivityHandler* getHandler() {
		return m_spHandler;
	}
	
	static void setHandler(AbstractNetworkActivityHandler* handler) {
		m_spHandler = handler;
	}
private:
	enum { REPORT_DELAY = 500 }; // msec
	
	class Holder;
	class ReportCommand;
	friend class NetworkActivityReporter::Holder;
	
	static AbstractNetworkActivityHandler* m_spHandler;
	ACE_Time_Value m_lastReportTime;
	ACE_Time_Value m_reportDelay;
	ACE_Thread_Mutex m_mutex;
};

#endif
