/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HTTPSTREAMWRITER_H_
#define HTTPSTREAMWRITER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "types.h"
#include "SplittableBuffer.h"
#include "SBOutStream.h"
#include "NonCopyable.h"
#include <stddef.h>
#include <memory>

class AbstractDataConsumer;
class HttpRequestMetadata;
class HttpResponseMetadata;
class HttpMessageMetadata;
class HttpRequestLine;
class HttpStatusLine;
class HttpHeadersCollection;
class HttpVersion;
class URI;

class HttpStreamWriter : public NonCopyable
{
public:
	HttpStreamWriter(AbstractDataConsumer& consumer);
	
	void startRequest(HttpRequestMetadata& metadata,
		bool set_conn_close, bool through_proxy, bool chunked_ok);
	
	void startResponse(HttpResponseMetadata& metadata,
		HttpVersion const& max_http_vers, bool set_conn_close);
	
	void appendBodyData(SplittableBuffer& data, bool eof);
	
	void reset();
	
	bool isConnCloseSet() const { return m_isConnClose; }
	
	size_t getBufferedBodyDataSize() const { return m_bufferedBodyPart.size(); }
private:
	enum State { 
		WAITING_FOR_METADATA,
		FLAT_BODY,
		BUFFERED_FLAT_BODY,
		CHUNKED_BODY
	};
	enum { BUFFER_CHUNKS_LESS_THAN = 256 }; // can't be 0
	
	void output(bool eof=false);
	
	void processRequestLine(HttpRequestLine& request_line, bool through_proxy);
	
	void processStatusLine(HttpStatusLine& status_line, HttpVersion const& http_vers);
	
	void prepareCommonHeaders(HttpHeadersCollection& headers);
	
	void prepareRequestHeaders(HttpHeadersCollection& headers, URI const& request_uri);
	
	void prepareResponseHeaders(HttpHeadersCollection& headers) { prepareCommonHeaders(headers); }
	
	void prepareForbiddenBodyMode(
		HttpHeadersCollection& headers, bool set_conn_close);
	
	void prepareSizedFlatMode(
		HttpHeadersCollection& headers, bool set_conn_close, uintmax_t body_size);
	
	void prepareUnsizedFlatMode(
		HttpHeadersCollection& headers, bool set_conn_close);
	
	void prepareBufferedFlatMode(
		HttpHeadersCollection& headers, bool set_conn_close);
	
	void prepareChunkedMode(
		HttpHeadersCollection& headers, bool set_conn_close);
	
	void handleConnClose(HttpHeadersCollection& headers, bool set_conn_close);
	
	//void prependChunkHeader(size_t size);
	
	AbstractDataConsumer& m_rConsumer;
	SBOutStream m_outStream;
	SplittableBuffer m_bufferedBodyPart;
	State m_state;
	bool m_isEOF;
	bool m_isConnClose;
};

#endif

