/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HtmlNode.h"
#include <cassert>

using namespace std;

HtmlNode::HtmlNode()
:	m_pParent(0),
	m_pPrev(this),
	m_pNext(this)
{
}

HtmlNode::HtmlNode(HtmlNode* parent)
:	m_pParent(parent)
{
	ref();
}

HtmlNode::~HtmlNode()
{
	m_pPrev->m_pNext = m_pNext;
	m_pNext->m_pPrev = m_pPrev;
}

void
HtmlNode::makeSentinelPair(HtmlNode* left, HtmlNode* right)
{
	left->m_pPrev = right->m_pPrev = left;
	left->m_pNext = right->m_pNext = right;
}

void
HtmlNode::insertAfter(HtmlNode* node)
{
	assert(!m_pParent);
	m_pPrev = node;
	m_pNext = node->m_pNext;
	node->m_pNext = this;
	m_pNext->m_pPrev = this;
	if ((m_pParent = node->m_pParent)) {
		ref();
	}
}

void
HtmlNode::insertBefore(HtmlNode* node)
{
	assert(!m_pParent);
	m_pNext = node;
	m_pPrev = node->m_pPrev;
	node->m_pPrev = this;
	m_pPrev->m_pNext = this;
	if ((m_pParent = node->m_pParent)) {
		ref();
	}
}

void
HtmlNode::detachFromParent()
{
	assert(m_pParent);
	m_pPrev->m_pNext = m_pNext;
	m_pNext->m_pPrev = m_pPrev;
	if (unref()) {
		m_pPrev = m_pNext = this;
		m_pParent = 0;
	}
}

HtmlNode*
HtmlNode::getNextSibling()
{
	return m_pNext == m_pNext->m_pNext ? 0 : m_pNext;
}

const HtmlNode*
HtmlNode::getNextSibling() const
{
	return m_pNext == m_pNext->m_pNext ? 0 : m_pNext;
}

HtmlNode*
HtmlNode::getPrevSibling()
{
	return m_pPrev == m_pPrev->m_pPrev ? 0 : m_pPrev;
}

const HtmlNode*
HtmlNode::getPrevSibling() const
{
	return m_pPrev == m_pPrev->m_pPrev ? 0 : m_pPrev;
}
