/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef FLASHHEURISTICSCORE_H_
#define FLASHHEURISTICSCORE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HeuristicScore.h"
#include <string>

class URI;

class FlashHeuristicScore : public HeuristicScore
{
public:
	FlashHeuristicScore(int score = 0) : m_score(score), m_sizeScore(0) {}
	
	virtual int getNumericScore() const;
	
	virtual int getNumericSizeScore() const;
	
	virtual Status getStatus() const;
	
	void processPageHint(int hint) { m_score += hint; }
	
	void processSize(int width, int height); // use -1 for undefined
	
	// used when marking an image for analyzing, as size will be processed again
	void unprocessSize();
	
	void processUrl(URI const& abs, URI const& rel, URI const& base);
	
	void processOptions(bool loop, bool menu);
	
	// level 0: no script, 1: from script, 2: from script inside script, ...
	void processScriptLevel(int level, bool external);
	
	// was there a redirect when fetching an external script?
	void processScriptRedirect(bool val); 
	
	// were persistent cookies sent when fetching an external script?
	void processScriptPersistentCookies(bool val);
private:
	static double getAspect(int width, int height);
	
	int m_score;
	int m_sizeScore;
};

#endif
