/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "DownloadSizeLimiter.h"
#include "HttpResponseMetadata.h"
#include "ResponseErrorInitiator.h"
#include "ErrorDescriptor.h"
#include "ErrorCodes.h"

using namespace std;

DownloadSizeLimiter::DownloadSizeLimiter(
	ResponseFilterChain& filter_chain, uintmax_t size_limit)
:	ResponseFilterBase(filter_chain),
	m_sizeLimit(size_limit)
{
}

DownloadSizeLimiter::~DownloadSizeLimiter()
{
}

void
DownloadSizeLimiter::processMetadata(
	std::auto_ptr<HttpResponseMetadata> metadata)
{
	if (metadata->getBodyStatus() == HttpResponseMetadata::BODY_SIZE_KNOWN
	    && metadata->getBodySize() > m_sizeLimit) {
		raiseError();
	} else {
		outputMetadata(metadata);
	}
}

void
DownloadSizeLimiter::processBodyData(SplittableBuffer& data, bool eof)
{
	if (getFilterChain().getDownloadProgress().received() > m_sizeLimit) {
		raiseError();
	} else {
		outputBodyData(data, eof);
	}
}

void
DownloadSizeLimiter::raiseError()
{
	getFilterChain().getErrorInitiator().raiseError(
		auto_ptr<ErrorDescriptor>(new ErrorDescriptor(
			ErrorCodes::RESPONSE_BODY_TOO_BIG,
			"response body is too big"
		))
	);
}
