/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef DEBUG_H_
#define DEBUG_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AbstractDebugAgent.h"

#if !defined(DEBUG) || defined(WIN32)

#define DEBUGLOG(what)
#define DEBUGLOG2(what)
#define DBG_TRAFFIC_TO_SERVER(traf)
#define DBG_TRAFFIC_FROM_SERVER(traf)
#define DBG_TRAFFIC_TO_CLIENT(traf)
#define DBG_TRAFFIC_FROM_CLIENT(traf)
#define DBG_TRAFFIC_TO_SCRIPT_SERVER(traf)
#define DBG_TRAFFIC_FROM_SCRIPT_SERVER(traf)
#define DBG_CLIENT_CONNECTION_BEGIN()
#define DBG_CLIENT_CONNECTION_END()
#define DBG_REGISTER_CLIENT_REQUEST(metadata)
#define DBG_HTTP_MESSAGE_BEGIN(metadata, type)
#define DBG_HTTP_MESSAGE_END(type)
#define DBG_HTTP_MESSAGE_ERROR(type)
#define DBG_INCOMING_REQUEST_BEGIN(metadata)
#define DBG_INCOMING_REQUEST_END()
#define DBG_INCOMING_REQUEST_ERROR();
#define DBG_OUTGOING_REQUEST_BEGIN(metadata)
#define DBG_OUTGOING_REQUEST_END()
#define DBG_OUTGOING_REQUEST_ERROR()
#define DBG_INCOMING_RESPONSE_BEGIN(metadata)
#define DBG_INCOMING_RESPONSE_END()
#define DBG_INCOMING_RESPONSE_ERROR()
#define DBG_NORMAL_OUTGOING_RESPONSE_BEGIN(metadata)
#define DBG_FILTERED_OUTGOING_RESPONSE_BEGIN(metadata)
#define DBG_CRAFTED_OUTGOING_RESPONSE_BEGIN(metadata)
#define DBG_ERROR_OUTGOING_RESPONSE_BEGIN(metadata)
#define DBG_OUTGOING_RESPONSE_END()
#define DBG_OUTGOING_RESPONSE_ERROR()
#define DBG_SCRIPT_REQUEST_BEGIN(metadata)
#define DBG_SCRIPT_REQUEST_END()
#define DBG_SCRIPT_REQUEST_ERROR()
#define DBG_SCRIPT_RESPONSE_BEGIN(metadata)
#define DBG_SCRIPT_RESPONSE_END()
#define DBG_SCRIPT_RESPONSE_ERROR()

#else

#include <sstream>
#include <string>
#include <stdlib.h> // for abort()

#define DEBUGLOG(what)                                        \
{                                                             \
	ostringstream strm__;                                 \
	strm__ << what;                                       \
	Debug::instance()->logMessage(strm__.str()); \
}

#define DEBUGLOG2(what) \
DEBUGLOG(what << " [" << __FILE__ << ':' << __LINE__ << ']')

#define DBG_TRAFFIC_TO_SERVER(traf) \
Debug::instance()->logTraffic(traf, AbstractDebugAgent::TO_SERVER)

#define DBG_TRAFFIC_FROM_SERVER(traf) \
Debug::instance()->logTraffic(traf, AbstractDebugAgent::FROM_SERVER)

#define DBG_TRAFFIC_TO_CLIENT(traf) \
Debug::instance()->logTraffic(traf, AbstractDebugAgent::TO_CLIENT)

#define DBG_TRAFFIC_FROM_CLIENT(traf) \
Debug::instance()->logTraffic(traf, AbstractDebugAgent::FROM_CLIENT)

#define DBG_TRAFFIC_TO_SCRIPT_SERVER(traf) \
Debug::instance()->logTraffic(traf, AbstractDebugAgent::TO_SCRIPT_SERVER)

#define DBG_TRAFFIC_FROM_SCRIPT_SERVER(traf) \
Debug::instance()->logTraffic(traf, AbstractDebugAgent::FROM_SCRIPT_SERVER)

#define DBG_CLIENT_CONNECTION_BEGIN() \
Debug::instance()->clientConnectionBegin()

#define DBG_CLIENT_CONNECTION_END() \
Debug::instance()->clientConnectionEnd()

#define DBG_REGISTER_CLIENT_REQUEST(metadata) \
Debug::instance()->registerClientRequest(metadata)

#define DBG_HTTP_MESSAGE_BEGIN(metadata, type) \
Debug::instance()->httpMessageBegin(type, metadata)

#define DBG_HTTP_MESSAGE_END(type) \
Debug::instance()->httpMessageEnd(type)

#define DBG_HTTP_MESSAGE_ERROR(type) \
Debug::instance()->httpMessageEnd(type, true)

#define DBG_INCOMING_REQUEST_BEGIN(metadata) \
DBG_HTTP_MESSAGE_BEGIN(metadata, AbstractDebugAgent::INCOMING_REQUEST)

#define DBG_INCOMING_REQUEST_END() \
DBG_HTTP_MESSAGE_END(AbstractDebugAgent::INCOMING_REQUEST)

#define DBG_INCOMING_REQUEST_ERROR() \
DBG_HTTP_MESSAGE_ERROR(AbstractDebugAgent::INCOMING_REQUEST)

#define DBG_OUTGOING_REQUEST_BEGIN(metadata) \
DBG_HTTP_MESSAGE_BEGIN(metadata, AbstractDebugAgent::OUTGOING_REQUEST)

#define DBG_OUTGOING_REQUEST_END() \
DBG_HTTP_MESSAGE_END(AbstractDebugAgent::OUTGOING_REQUEST)

#define DBG_OUTGOING_REQUEST_ERROR() \
DBG_HTTP_MESSAGE_ERROR(AbstractDebugAgent::OUTGOING_REQUEST)

#define DBG_INCOMING_RESPONSE_BEGIN(metadata) \
DBG_HTTP_MESSAGE_BEGIN(metadata, AbstractDebugAgent::INCOMING_RESPONSE)

#define DBG_INCOMING_RESPONSE_END() \
DBG_HTTP_MESSAGE_END(AbstractDebugAgent::INCOMING_RESPONSE)

#define DBG_INCOMING_RESPONSE_ERROR() \
DBG_HTTP_MESSAGE_ERROR(AbstractDebugAgent::INCOMING_RESPONSE)

#define DBG_UNMODIFIED_OUTGOING_RESPONSE_BEGIN(metadata) \
DBG_HTTP_MESSAGE_BEGIN(metadata, AbstractDebugAgent::UNMODIFIED_OUTGOING_RESPONSE)

#define DBG_FILTERED_OUTGOING_RESPONSE_BEGIN(metadata) \
DBG_HTTP_MESSAGE_BEGIN(metadata, AbstractDebugAgent::FILTERED_OUTGOING_RESPONSE)

#define DBG_CRAFTED_OUTGOING_RESPONSE_BEGIN(metadata) \
DBG_HTTP_MESSAGE_BEGIN(metadata, AbstractDebugAgent::CRAFTED_OUTGOING_RESPONSE)

#define DBG_ERROR_OUTGOING_RESPONSE_BEGIN(metadata) \
DBG_HTTP_MESSAGE_BEGIN(metadata, AbstractDebugAgent::ERROR_OUTGOING_RESPONSE)

#define DBG_OUTGOING_RESPONSE_END() \
DBG_HTTP_MESSAGE_END(AbstractDebugAgent::OUTGOING_RESPONSE)

#define DBG_OUTGOING_RESPONSE_ERROR() \
DBG_HTTP_MESSAGE_ERROR(AbstractDebugAgent::OUTGOING_RESPONSE)

#define DBG_SCRIPT_REQUEST_BEGIN(metadata) \
DBG_HTTP_MESSAGE_BEGIN(metadata, AbstractDebugAgent::SCRIPT_REQUEST)

#define DBG_SCRIPT_REQUEST_END() \
DBG_HTTP_MESSAGE_END(AbstractDebugAgent::SCRIPT_REQUEST)

#define DBG_SCRIPT_REQUEST_ERROR() \
DBG_HTTP_MESSAGE_ERROR(AbstractDebugAgent::SCRIPT_REQUEST)

#define DBG_SCRIPT_RESPONSE_BEGIN(metadata) \
DBG_HTTP_MESSAGE_BEGIN(metadata, AbstractDebugAgent::SCRIPT_RESPONSE)

#define DBG_SCRIPT_RESPONSE_END() \
DBG_HTTP_MESSAGE_END(AbstractDebugAgent::SCRIPT_RESPONSE)

#define DBG_SCRIPT_RESPONSE_ERROR() \
DBG_HTTP_MESSAGE_ERROR(AbstractDebugAgent::SCRIPT_RESPONSE)


class HttpRequestMetadata;
class HttpResponseMetadata;
class SplittableBuffer;

class Debug
{
public:
	typedef AbstractDebugAgent::TrafficDirection TrafficDirection;
	typedef AbstractDebugAgent::HttpMessageType HttpMessageType;
private:
	Debug() : m_requestIdGenerator(0) {}
	
	Debug(Debug const&);
	
	Debug& operator=(Debug&);
public:
	void clientConnectionBegin();
	
	void clientConnectionEnd();
	
	void registerClientRequest(HttpRequestMetadata& metadata);
	
	void httpMessageBegin(
		HttpMessageType type, HttpRequestMetadata const& metadata);
	
	void httpMessageBegin(
		HttpMessageType type, HttpResponseMetadata const& metadata);
	
	void httpMessageEnd(HttpMessageType type, bool error = false);
	
	void logMessage(std::string const& msg);
	
	void logTraffic(SplittableBuffer const& traf, TrafficDirection dir);
	
	static Debug* instance();
	
	static AbstractDebugAgent* getAgent() { return m_spAgent; }
	
	static void setAgent(AbstractDebugAgent* agent) { m_spAgent = agent; }
private:
	class Holder;
	class ClientConnectionBeginCommand;
	class ClientConnectionEndCommand;
	class RegisterClientRequestCommand;
	class HttpMessageBeginCommand;
	class HttpMessageEndCommand;
	class LogMessageCommand;
	class LogTrafficCommand;
	
	void httpMessageBegin(
		HttpMessageType type, int request_id,
		std::string const& headers);
	
	static AbstractDebugAgent* m_spAgent;
	int m_requestIdGenerator; // doesn't need to be globally unique
};

#endif // DEBUG

#endif // DEBUG_H_
