/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef CONNACCEPTOR_H_
#define CONNACCEPTOR_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include "IntrusivePtr.h"
#include "RefCountableSAP.h"
#include "WorkerThreadPool.h"
#include "Reactor.h"
#include <memory>

class ACE_SOCK_Acceptor;

class ConnAcceptor
{
	DECLARE_NON_COPYABLE(ConnAcceptor)
public:
	typedef IntrusivePtr<RefCountableSAP<ACE_SOCK_Acceptor> > AcceptorPtr;
	
	ConnAcceptor(bool stop_on_signals = true);
	
	~ConnAcceptor();
	
	WorkerThreadPool& workerPool() { return m_workerPool; }
	
	bool add(AcceptorPtr const& acceptor);
	
	void remove(AcceptorPtr const& acceptor);
	
	void removeAll();
	
	int acceptConnections();
	
	void forceStop();
private:
	class EH;
	
	std::auto_ptr<Reactor> m_ptrReactor;
	WorkerThreadPool m_workerPool;
};

#endif
