/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ABSTRACTDEBUGAGENT_H_
#define ABSTRACTDEBUGAGENT_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <ace/OS_NS_Thread.h>
#include <string>

class InterthreadCommandQueue;
class SplittableBuffer;

class AbstractDebugAgent
{
public:
	enum TrafficDirection {
		FROM_CLIENT, TO_CLIENT,
		FROM_SERVER, TO_SERVER,
		TO_SCRIPT_SERVER, FROM_SCRIPT_SERVER
	};
	enum HttpMessageType {
		INCOMING_REQUEST, OUTGOING_REQUEST,
		INCOMING_RESPONSE, OUTGOING_RESPONSE,
		UNMODIFIED_OUTGOING_RESPONSE, FILTERED_OUTGOING_RESPONSE,
		CRAFTED_OUTGOING_RESPONSE, ERROR_OUTGOING_RESPONSE,
		SCRIPT_REQUEST, SCRIPT_RESPONSE,
		NUM_HTTP_MESSAGE_TYPES
	};
	
	virtual ~AbstractDebugAgent() {}
	
	virtual InterthreadCommandQueue& getCommandQueue() = 0;
	
	virtual void clientConnectionBegin(ACE_thread_t thread_id) = 0;
	
	virtual void clientConnectionEnd(ACE_thread_t thread_id) = 0;
	
	virtual void registerClientRequest(ACE_thread_t thread_id,
		int request_id, std::string request_url) = 0;
	
	virtual void httpMessageBegin(
		ACE_thread_t thread_id, int request_id,
		HttpMessageType type, std::string const& headers) = 0;
	
	virtual void httpMessageEnd(
		ACE_thread_t thread_id, HttpMessageType type, bool error) = 0;
	
	virtual void logMessage(ACE_thread_t thread_id, std::string const& msg) = 0;
	
	virtual void logTraffic(ACE_thread_t thread_id,
		SplittableBuffer& traf, TrafficDirection dir) = 0;
};

#endif
