/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef READWRITESINGLETON_H_
#define READWRITESINGLETON_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <ace/Synch.h>
#include <ace/Singleton.h>

template<typename T>
class ReadWriteSingleton
{
private:
	struct ObjectHolder
	{
		T object;
		ACE_RW_Thread_Mutex mutex;
	};
	typedef ACE_Singleton<ObjectHolder, ACE_Recursive_Thread_Mutex> OhSingleton;
public:
	class ReadAccessor
	{
	public:
		ReadAccessor();
		
		~ReadAccessor();
		
		T const& operator*() const { return m_pObjectHolder->object; }
		
		T const* operator->() const { return &m_pObjectHolder->object; }
	private:
		ObjectHolder* m_pObjectHolder;
	};
	
	class WriteAccessor
	{
	public:
		WriteAccessor();
		
		~WriteAccessor();
		
		T& operator*() const { return m_pObjectHolder->object; }
		
		T* operator->() const { return &m_pObjectHolder->object; }
	private:
		ObjectHolder* m_pObjectHolder;
	};
};


template<typename T>
ReadWriteSingleton<T>::ReadAccessor::ReadAccessor()
{
	m_pObjectHolder = OhSingleton::instance();
	m_pObjectHolder->mutex.acquire_read();
}

template<typename T>
ReadWriteSingleton<T>::ReadAccessor::~ReadAccessor()
{
	m_pObjectHolder->mutex.release();
}

template<typename T>
ReadWriteSingleton<T>::WriteAccessor::WriteAccessor()
{
	m_pObjectHolder = OhSingleton::instance();
	m_pObjectHolder->mutex.acquire_write();
}

template<typename T>
ReadWriteSingleton<T>::WriteAccessor::~WriteAccessor()
{
	m_pObjectHolder->mutex.release();
}

#endif
