#include "conf.h"
#include "extern.h"


void getword(char *word, char *line, char stop)
{
  int x = 0,y;
  int loop=0;
  int limit=10000;
  char wline[MAXLEN];

  strcpy(wline,line);

  if(strlen(line) < 3) {
     word[0]='\0';
     return;
  }

  for(x=0;((line[x]) && (line[x] != stop ));x++) {
     loop++;
     if(loop>limit) {
        printf("%s: loop detected.\n",PGM);
        printf("%s: Record=\"%s\"\n",PGM,wline);
        printf("%s: searching for \'x%x\'\n",PGM,stop);
        printf("%s: Maybe you have a broken record or garbage in your logmail file.\n",PGM);
        exit(1);
     }
     word[x] = line[x];
  }

  word[x] = '\0';
  if(line[x]) ++x;
    y=0;

  while((line[y++] = line[x++]));
 
  return;
}

static char mtab1[12][4]={"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};
static char mtab2[12][3]={"01","02","03","04","05","06","07","08","09","10","11","12"};

void fixmonth(char *dia, char *mes, char *data)
{
   char nmes[3];
   int  x;

   for(x=0; x<=12; x++) {
      if(strcmp(mtab1[x],mes) == 0)
         strcpy(nmes,mtab2[x]);
   }

   sprintf(data,"%s%s",nmes,dia);
   return;

}

char *subs(char *str, char *from, char *to)
{
   char *tmp;
   char *ret;
   int ss, st, x=0;

   if(strstr(str,from) == 0)
      return (char *) str;

   ss = strlen(str);
   st = strlen(to);

   ret = (char *) malloc(ss + st);
   for(x=0;x<=ss+st;x++)
      ret[x]='\0';

   tmp = strstr(str, from);
   if ( tmp == (char *) NULL )
      return (char *) NULL;

   strncpy(ret, str, ss-strlen(tmp));
   strncat(ret, to, strlen(to));
   strncat(ret, (tmp+strlen(from)), strlen(tmp+strlen(from)));

   return (char *) ret;

}

void getmailcw()
{

   if(strncmp(usesendmailcw,"no",2) == 0) {
      if(strlen(emaildomain) < 1) {
         cwind=0;
         return;
      }
      if((names=(char *) malloc(strlen(emaildomain)+10))==NULL) {
         fprintf(stderr, "%s: %s (%d)\n",PGM,msg04,nreg);
         fclose(ftmp);
         exit(1);
      }
      bzero(names,nreg);
      strcpy(names,emaildomain);
      strcat(names,":");
      cwind++;
      return;
   }

   if((ftmp=fopen(cwfile,"r"))==NULL) {
      if(cwind) return;
      else cwind=0;
   }

   nreg = lseek(fileno(ftmp), 0, SEEK_END);
   nreg = nreg+10;
   lseek(fileno(ftmp), 0, 0);

   if((names=(char *) malloc(nreg))==NULL) {
      fprintf(stderr, "%s: %s (%d)\n",PGM,msg04,nreg);
      fclose(ftmp);
      exit(1);
   }
   bzero(names,nreg);

   while(fgets(buf,300,ftmp)!=NULL) {
      if(strncmp(buf,"#",1) == 0)
         continue;
      if(strstr(buf,"\n") != 0)
         buf[strlen(buf)-1]='\0';
      strcat(names,buf);
      strcat(names,":");
      cwind++;
   }

   fclose(ftmp);

}

char *strlow(char *string)
{
      char *s;

      if (string)
      {
            for (s = string; *s; ++s)
                  *s = tolower(*s);
      }

      return string;
}

void fixnone(char *str)
{

   if(strstr(str,"\n") != 0)
      str[strlen(str)-1]='\0';
   if(strcmp(str,"none") == 0)
      str[0]='\0';

   return;
}


char *fixnum(long long int inteiro)
#define MAXIMO 1024
{
   char num[MAXIMO];
   char buf[MAXIMO * 2];
   char *pbuf;
   char ret[MAXIMO * 2];
   char *pret;
   register int i, j, k;

#if defined(__FreeBSD__)
   sprintf(num, "%qu", inteiro);
#elif defined(__alpha) || __ALPHA
   sprintf(num, "%ld", inteiro);
#else
   sprintf(num, "%lld", inteiro);
#endif

   for(i=0;i<MAXIMO*2;i++)


   for(i=0;i<MAXIMO*2;i++)
   buf[i]='\0';

   pbuf = buf;
   pret = ret;
   k = 0;

   for ( i = strlen(num) - 1, j = 0 ; i > -1; i--) {
      if ( k == 2 && i != 0 )  {
         k = 0;
         pbuf[j++] = num[i];
         if(strcmp(usecomma,"yes") == 0)
            pbuf[j++] = ',';
         else pbuf[j++] = '.';
         continue;
      }
      pbuf[j] = num[i];
      j++;
      k++;
   }

   pret[0]='\0';

   for ( i = strlen(pbuf) - 1, j = 0 ; i > -1; i--, j++)
      pret[j] = pbuf[i];

      pret[j] = '\0';

      return pret;
}


long long int my_atoll (const char *nptr)
{
  int offset=0, x;
  long long int returnval=0;
  char one_digit[2];

  one_digit[1]='\0';

  while (isspace(nptr[offset])) {
    offset++;
  }

  for(x=offset; x<=1024+offset && isdigit(nptr[x]); x++) {
    sprintf(one_digit, "%c", nptr[x]); //I don't know how else to do this
    returnval = (returnval * 10) + atoi(one_digit);
  }

  return returnval;

} 



void vrfydir(char *dir)
{
   int  num=1, count=0;
   char dir2[MAXLEN];
   char per1[MAXLEN];
   char per2[MAXLEN];

   strcpy(dir2,dir);
   if(strcmp(overwritereport,"no") == 0) {
      while(num) {
         if(access(dir2,R_OK) == 0) {
            sprintf(dir2,"%s.%d",dir,num);
            sprintf(per2,"%s.%d",per1,num);
            num++;
            count++;
         } else
            break;
      }
  
      if(count > 0) {
         rename(dir,dir2);
      }
   } else {
      if(access(dir,R_OK) == 0) {
         sprintf(wdir,"rm -r %s",dir);
         system(wdir);
      }
   }

   sprintf(wdir,"mkdir -p %s",dir);
   system(wdir);

   sprintf(dir2,"%s",wdir+9);

   return;

}


void zdate()
{

   tt = time(NULL);
   t = localtime(&tt);
   if(strcmp(dateformat,"ddmmyy") == 0)
      strftime(ftime, 127, "%d/%b/%Y %H:%M", t);
   if(strcmp(dateformat,"mmddyy") == 0)
      strftime(ftime, 127, "%b/%d/%Y-%H:%M", t);
   if(strcmp(dateformat,"yymmdd") == 0)
      strftime(ftime, 127, "%Y/%b/%d-%H:%M", t);

   return;
}


void debug(char *function, char *msg)
{
   if(debugflag)
      fprintf(stderr, "MAILMGR: %s %s\n",function,msg);
   return;
}

