
#include "conf.h"
#include "extern.h"

void mklastlog()
{

   if(strcmp(lastlog,"0") == 0)
      return;

   nreg=0;

   sprintf(logtemp,"%s/lastlog1",outdir);
   if((fou=fopen(logtemp,"w"))==NULL) {
      fprintf(stderr, "%s: %s: %s\n",PGM,msg01,logtemp);
      exit(1);
   }

   dirp = opendir(outdir);
   while ((direntp = readdir( dirp )) != NULL ){
      if(strstr(direntp->d_name,"-") == 0)
         continue;

      sprintf(warea,"%s/%s",outdir,direntp->d_name);
      stat(warea,&statb);
      tt=statb.st_ctime;
      t = localtime(&tt);
      strftime(ftime, 127, "%Y%m%d%H%M%S", t);
      sprintf(buf,"%s %s\n",ftime,direntp->d_name);
      fputs(buf,fou);
      nreg++;
   }

   (void)closedir( dirp );
   fclose(fou);
   
   sprintf(csort,"sort -n -k 1,1 -o %s/lastlog %s",outdir,logtemp);
   system(csort);

   unlink(logtemp);

   sprintf(logtemp,"%s/lastlog",outdir);
   if(nreg<=atoi(lastlog)) {
      if(access(logtemp, R_OK) == 0)
         unlink(logtemp);
      return;
   }

   nreg-=atoi(lastlog);

   if((ftmp=fopen(logtemp,"r"))==NULL) {
      fprintf(stderr, "%s: %s: %s\n",PGM,msg01,logtemp);
      exit(1);
   }

   while(fgets(buf,sizeof(buf),ftmp)!=NULL) {
      getword(warea,buf,' ');
      buf[strlen(buf)-1]='\0';
     
      if(nreg) {
         sprintf(zbuf,"rm -r %s/%s",outdir,buf);
         system(zbuf);
         nreg--;
      }
   }

   fclose(ftmp);
   sprintf(zbuf,"%s/lastlog",outdir);
   unlink(zbuf);
 
   return;
}
