/*
 * mailmgr  - Sendmail user management log
 * Nov/2000 - Pedro L Orso - orso@onda.com.br
 */

#include "conf.h"
#include "extern.h"

void makeindex()
{

   if(lastlog[0] != '\0')
      mklastlog();

   sprintf(wdir,"%s/index.html",outdir);
   debug("Making index file:",wdir);

   if((fou=fopen(wdir,"w"))==NULL) {
      fprintf(stderr, "%s: %s: %s\n",PGM,msg01,wdir);
      exit(1);
   }

   fputs("<html>\n",fou);

   sprintf(warea,"<body bgcolor=%s text=%s background='%s'>\n",backgroundcolor,textcolor,backgroundimage);
   fputs(warea,fou);

   fputs("<center>\n",fou);

   if(strlen(logoimage) > 0) {
      sprintf(warea,"<tr><th align=left><img src='%s' border=0 align=absmiddle width=%s height=%s>      \
                <font color=%s face='%s',size=%s>%s</font>\n",                                          \
                logoimage,width,height,logotextcolor,logofontface,logofontsize,logotext);
      fputs(warea,fou);
   }

   sprintf(warea,"<font face='%s' color=%s size=%s>%s</font><br>\n",                                    \
                titlefontface,titlecolor,titlefontsize,title);
   fputs(warea,fou);
   fputs("</center>\n",fou);

   fputs("<center><table cellpadding=1 cellspacing=1>\n",fou);
   fputs("<tr><td></td><td></td></tr>",fou);

   sprintf(warea,"<tr><th bgcolor=%s><font size=%s color=%s>%s</font></th>				\
		<td>&nbsp;</td>										\
		<th bgcolor=%s><font size=%s color=%s>%s</font></th></tr>\n",				\
		headerbgcolor,headerfontsize,headercolor,htm13,						\
		headerbgcolor,headerfontsize,headercolor,htm14);
   fputs(warea,fou);

   dirp = opendir(outdir);

   while ( (direntp = readdir( dirp )) != NULL ){
      if(strstr(direntp->d_name,"-") == 0)
         continue;

      sprintf(warea,"%s/%s",outdir,direntp->d_name);
      stat(warea,&statb);
      tt=statb.st_ctime;

      t=localtime(&tt);
      strftime(ftime, 127, "%a %b %d %H:%M:%S %Y", t);

      sprintf(warea,"<tr><td bgcolor=%s><font size=%s><a href='%s/topuser.html'>%s</font></a></td>			\
		<td>&nbsp;</td>										\
		<td bgcolor=%s><font size=%s>%s</font></td></tr>\n",					\
		textbgcolor,textfontsize,direntp->d_name,direntp->d_name,				\
		textbgcolor,textfontsize,ftime);
      fputs(warea,fou);
   }

   (void)closedir( dirp );

   strcpy(warea,"</table></center>");
   fputs(warea,fou);

   zdate(ftime, dateformat);
   sprintf(warea,"<br><br><center><font size=-2>%s <a href='%s'>%s-%s</a> %s %s</font></center>\n",htm15,URL,PGM,VERSION,htm16,ftime);
   fputs(warea,fou);

   strcpy(warea,"</html\n>");
   fputs(warea,fou);

   return;
}
