#include "conf.h"
#include "extern.h"

void getconf()
{

   if((ftmp=fopen(configfile,"r"))==NULL) {
      fprintf(stderr, "%s: %s: %s\n",PGM,msg01,configfile);
      exit(1);
   }

   while (fgets(buf, MAXLEN, ftmp) != NULL) {
      if(strstr(buf,"\n") != 0)
         buf[strlen(buf)-1]='\0';

      if(strncmp(buf,"#",1) == 0)
         continue;

      if(strstr(buf,"logfile") != 0 && logfile[0] == '\0') {
         getword(wbuf,buf,' ');
         strcpy(logfile,buf);
         fixnone(logfile);
      }

      if(strstr(buf,"temporary_dir") != 0) {
         getword(wbuf,buf,' ');
         strcpy(tempdir,buf);
         fixnone(tempdir);
      }

      if(strstr(buf,"output_dir") != 0) {
         getword(wbuf,buf,' ');
         strcpy(outdir,buf);
         fixnone(outdir);
      }

      if(strstr(buf,"title") != 0) {
         if(strstr(buf,"_") == 0) {
            getword(wbuf,buf,'"');
            getword(title,buf,'"');
            fixnone(title);
	 }
      }

      if(strstr(buf,"sendmail_cw") != 0) {
         if(strstr(buf,"use_sendmail_cw") != 0) {
            getword(wbuf,buf,' ');
            strcpy(usesendmailcw,buf);
            fixnone(usesendmailcw);
            continue;
         }
         getword(wbuf,buf,' ');
         strcpy(cwfile,buf);
         fixnone(cwfile);
      }

      if(strstr(buf,"email_domain") != 0) {
         getword(wbuf,buf,' ');
         strcpy(emaildomain,buf);
         cwind++;
         fixnone(emaildomain);
      }

      if(strstr(buf,"background_color") != 0) {
         getword(wbuf,buf,' ');
         strcpy(backgroundcolor,buf);
         fixnone(backgroundcolor);
      }

      if(strstr(buf,"text_color") != 0) {
         if(strstr(buf,"logo_text_color") == 0) {
            getword(wbuf,buf,' ');
            strcpy(textcolor,buf);
            fixnone(textcolor);
         }
      }

      if(strstr(buf,"text_bgcolor") != 0) {
         getword(wbuf,buf,' ');
         strcpy(textbgcolor,buf);
         fixnone(textbgcolor);
      }

      if(strstr(buf,"relay_color") != 0) {
         getword(wbuf,buf,'"');
         getword(wbuf,buf,'"');
         strcpy(relaycolor,buf);
         fixnone(relaycolor);
      }

      if(strstr(buf,"title_color") != 0) {
         getword(wbuf,buf,' ');
         strcpy(titlecolor,buf);
         fixnone(titlecolor);
      }

      if(strstr(buf,"logo_image") != 0) {
         getword(wbuf,buf,' ');
         strcpy(logoimage,buf);
         fixnone(logoimage);
      }

      if(strstr(buf,"logo_text") != 0) {
         if(strstr(buf,"logo_text_color") == 0) {
            getword(wbuf,buf,'"');
            getword(logotext,buf,'"');
            fixnone(logotext);
         }
      }

      if(strstr(buf,"logo_text_color") != 0) {
         getword(wbuf,buf,' ');
         strcpy(logotextcolor,buf);
         fixnone(logotextcolor);
      }

      if(strstr(buf,"background_image") != 0) {
         getword(wbuf,buf,' ');
         strcpy(backgroundimage,buf);
         fixnone(backgroundimage);
      }

      if(strstr(buf,"logo_font_face") != 0) {
         getword(wbuf,buf,'"');
         getword(logofontface,buf,'"');
         fixnone(logofontface);
      }

      if(strstr(buf,"title_font_face") != 0) {
         getword(wbuf,buf,'"');
         getword(titlefontface,buf,'"');
         fixnone(titlefontface);
      }

      if(strstr(buf,"header_font_face") != 0) {
         getword(wbuf,buf,'"');
         getword(headerfontface,buf,'"');
         fixnone(headerfontface);
      }

      if(strstr(buf,"text_font_face") != 0) {
         getword(wbuf,buf,'"');
         getword(textfontface,buf,'"');
         fixnone(textfontface);
      }

      if(strstr(buf,"header_color") != 0) {
         getword(wbuf,buf,' ');
         strcpy(headertextcolor,buf);
         fixnone(headertextcolor);
      }

      if(strstr(buf,"header_bgcolor") != 0) {
         getword(wbuf,buf,' ');
         strcpy(headerbgcolor,buf);
         fixnone(headerbgcolor);
      }

      if(strstr(buf,"logo_font_size") != 0) {
         getword(wbuf,buf,' ');
         strcpy(logofontsize,buf);
         fixnone(logofontsize);
      }

      if(strstr(buf,"title_font_size") != 0) {
         getword(wbuf,buf,' ');
         strcpy(titlefontsize,buf);
         fixnone(titlefontsize);
      }

      if(strstr(buf,"header_font_size") != 0) {
         getword(wbuf,buf,' ');
         strcpy(headerfontsize,buf);
         fixnone(headerfontsize);
      }

      if(strstr(buf,"text_font_size") != 0) {
         getword(wbuf,buf,' ');
         strcpy(textfontsize,buf);
         fixnone(textfontsize);
      }

      if(strstr(buf,"image_size") != 0) {
         if(strstr(buf,"image_size") != 0) {
            getword(wbuf,buf,' ');
            getword(width,buf,' ');
            strcpy(height,buf);
            fixnone(width);
            fixnone(height);
         debug("Config height=",height);
         }
      }

      if(strstr(buf,"topuser_sort_field") != 0) {
         getword(wbuf,buf,' ');
         getword(topusersortfield,buf,' ');
         strcpy(topusersortorder,buf);
         fixnone(topusersortfield);
         fixnone(topusersortorder);
      }

      if(strstr(buf,"exclude_users") != 0) {
         getword(wbuf,buf,' ');
         strcpy(excludeusers,buf);
         fixnone(excludeusers);
      }

      if(strstr(buf,"lastlog") != 0) {
         getword(wbuf,buf,' ');
         strcpy(lastlog,buf);
         fixnone(lastlog);
      }

      if(strstr(buf,"overwrite_report") != 0) {
         getword(wbuf,buf,' ');
         strcpy(overwritereport,buf);
         fixnone(overwritereport);
      }

      if(strstr(buf,"date_format") != 0) {
         getword(wbuf,buf,' ');
         strcpy(dateformat,buf);
         fixnone(dateformat);
      }

      if(strstr(buf,"use_comma") != 0) {
         getword(wbuf,buf,' ');
         strcpy(usecomma,buf);
         fixnone(usecomma);
      }

   }

   fclose(ftmp);

   if(debugflag) {
      debug("Config temporary_dir=",tempdir);
      debug("Config output_dir=",outdir);
      debug("Config title=",title);
      debug("Config sendmail_cw=",cwfile);
      debug("Config background_color=",backgroundcolor);
      debug("Config text_color=",textcolor);
      debug("Config text_bgcolor=",textbgcolor);
      debug("Config relay_color=",relaycolor);
      debug("Config title_color=",titlecolor);
      debug("Config logo_image=",logoimage);
      debug("Config logo_text=",logotext);
      debug("Config logo_text_color=",logotextcolor);
      debug("Config background_image=",backgroundimage);
      debug("Config logo_font_face=",logofontface);
      debug("Config title_font_face=",titlefontface);
      debug("Config header_font_face=",headerfontface);
      debug("Config text_font_face=",textfontface);
      debug("Config header_color=",headertextcolor);
      debug("Config header_bgcolor=",headerbgcolor);
      debug("Config logo_font_size=",logofontsize);
      debug("Config title_font_size=",titlefontsize);
      debug("Config header_font_size=",headerfontsize);
      debug("Config text_font_size=",textfontsize);
      debug("Config width=",width);
      debug("Config height=",height);
      debug("Config lastlog=",lastlog);
      debug("Config overwrite_report=",overwritereport);
      debug("Config date_format=",dateformat);
      debug("Config user_comma=",usecomma);
   }

   return;
}
