#!/bin/sh
######################################################
# In order to minimize changes to the initrd file
# all movix scripts are kept out of it and copied
# at boot-time from CD to RAM.
####
# The main thing that this rc.S does is copying 
# from CD the rc.movix where all important 
# instructions are kept.
###########################

# remove /etc/mtab* so mount creates the /etc/mtab file
/bin/rm -f /etc/mtab* /etc/nologin

/sbin/syslogd 2> /dev/null
sleep 1
/sbin/klogd -c 3 1> /dev/null
#sleep 1
	
/bin/mount -av -t nonfs

/sbin/depmod -a

# Start devfsd if necessary
if [ -r /dev/.devfsd ]  ;   then
  if [ -x /sbin/devfsd ] ;   then
    echo "Starting devfs daemon:          /sbin/devfsd /dev"
    /sbin/devfsd /dev
  fi
fi

##############################################
#     Detect & load SCSI modules             #
## due to poor pcimap support of SCSI devs  ##
##############################################
if grep -iq SCSI /proc/pci;
  then
    MODDIR=`uname -r`
    if [ `find /lib/modules/$MODDIR/kernel/drivers/scsi/ -name $SCSI.o` ] ;  then
      echo "Loading $SCSI module..."
      modprobe -s $SCSI >> /tmp/modprobe.log 2>> /tmp/modprobe.log
    fi
    if [ -z $SCSI ] ;  then
      echo "Trying to find the module for your SCSI controller..."
      for i in `find /lib/modules/$MODDIR/kernel/drivers/scsi/ -name "*.o" | sort | sed 's/^.*\/// ;  s/.o$//'`;
      do
	J=0
	for j in `ls /proc/scsi/ 2>/dev/null` ; do J=$(($J+1)); done
	if [ $J -le 1 ] ;  then
  	  modprobe -s $i >> /tmp/modprobe.log 2>> /tmp/modprobe.log
	fi
	J=0
	## when a card is found, a new dir is created in the /proc/scsi/ directory :-)
	for j in `ls /proc/scsi/ 2>/dev/null` ; do J=$(($J+1)); done
	if [ $J -le 1 ] ; then 
	   rmmod $i 2>/dev/null
        else
	   echo "Loaded $i module!"
	   modprobe -s sr_mod >> /tmp/modprobe.log 2>> /tmp/modprobe.log
	   break		
	fi
      done
    fi
    J=0
    for j in `ls /proc/scsi/ 2>/dev/null` ; do J=$(($J+1)); done
    if [ $J -le 1 ] ; then
	echo "no SCSI module was succesfully loaded :-(";
	sleep 1	 
    fi 
fi

############################
## Mounting MoviX CD...
###############
for drive in /dev/cdroms/*      ;
  do
    echo "Attempting to finding MoviX cdrom in $drive"
    if ! mount -r -t iso9660 $drive /cdrom ;
     then
       continue
    else
       if [ -e /cdrom/movix/rc.movix ] ;
          then
            echo "Found MoviX cd in $drive!"
	    cp /cdrom/movix/rc.movix /etc/rc.d
	    chmod a+x /etc/rc.d/rc.movix
            break
       else
            umount /cdrom
            continue
       fi
    fi
done

#######################################
# Checking that everything went ok
###############
if [ ! -e /etc/rc.d/rc.movix ]
 then

                cat <<ALAS

Sorry, either the MoviX script could not load your
MoviX CD or an important movix script is missing.
In any case MoviX can't go on :-(

Possible explanations for this failure can be:
	
- You have too little RAM (less than about 40 MB).
- You have an unusual or non-standard CD-ROM drive (especially on certain
  laptops, which require you to pass parameters to the kernel at boot time).
- You have a corrupt or damaged CD-ROM image.

If you believe that your system should be supported and you do not
understand why you are seeing this message, you may ask for help
on the MoviX Help Forum.
Please visit

        http://movix.sf.net/

for more information.

ALAS
fi

###################################################
##  Finally we can start interesting stuff...
##########
/etc/rc.d/rc.movix
