#!/bin/sh
######################################################
# In order to minimize changes to the initrd file
# all movix scripts are kept out of it and copied
# at boot-time from CD to RAM.
####
# The main thing that this rc.S does is copying 
# from CD the rc.movix where all important 
# instructions are kept.
###########################

# remove /etc/mtab* so mount creates the /etc/mtab file
/bin/rm -f /etc/mtab* /etc/nologin
ln -s /proc/mounts  /etc/mtab
/bin/mount -av -t nonfs

/sbin/syslogd 2> /dev/null
sleep 1
/sbin/klogd 1> /dev/null
	
/sbin/depmod -a

# Start devfsd if necessary
if [ -r /dev/.devfsd ]  ;  then
  if [ -x /sbin/devfsd ];  then
    echo "Starting devfs daemon:          /sbin/devfsd /dev"
    /sbin/devfsd /dev
  fi
fi

# initialize bootsplash stuff...
#splash=silent
bs=yes

res=`/usr/sbin/fbresolution`
bsconf=/etc/bootsplash/themes/current/config/bootsplash-$res.cfg

box() { true; } # ignore box descriptions in the config file
if [ -e $bsconf ] ;  then
  . $bsconf
else
  bs=no
fi	

### first splash screen msg
if [ $bs = yes ] ; then
  /usr/sbin/fbtruetype -x $text_x -y $text_y -t $text_color -s $text_size "Kernel loaded!"
  echo "show 15000" > /proc/splash
fi

##############################################
#     Detect & load SCSI modules             #
## due to poor pcimap support of SCSI devs  ##
##############################################
if grep -iq SCSI /proc/pci;
  then
    MODDIR=`uname -r`
    if [ `find /lib/modules/$MODDIR/kernel/drivers/scsi/ -name $SCSI.o.gz` ] ; then
      echo "Loading $SCSI module..."
      modprobe -s $SCSI >> /tmp/modprobe.log 2>> /tmp/modprobe.log
    fi
    if [ -z $SCSI ]	;   then
      echo "Trying to find the module for your SCSI controller..."
      for i in `find /lib/modules/$MODDIR/kernel/drivers/scsi/ -name "*.o.gz" \
    		| sort \
		| sed 's!^.*/\(..*\)\.o\.gz$!\1!'`
      do
        J=0
        for j in `ls /proc/scsi/ 2>/dev/null` ;  do J=$(($J+1)); done
        if [ $J -le 1 ] ;   then
          modprobe -s $i >> /tmp/modprobe.log 2>> /tmp/modprobe.log
        fi
        J=0
        ## when a card is found, a new dir is created in the /proc/scsi/ directory :	-)
        for j in `ls /proc/scsi/ 2>/dev/null` ;  do J=$(($J+1)); done
        if [ $J -le 1 ] ;  then
           rmmod $i 2>/dev/null
        else
           echo "Loaded $i module!"
	   modprobe -s sr_mod >> /tmp/modprobe.log 2>> /tmp/modprobe.log
	   break
        fi
      done
    fi
    J=0
    for j in `ls /proc/scsi/ 2>/dev/null` ;  do J=$(($J+1)); done
    if [ $J -le 1 ]	;  then
        echo "no SCSI module was succesfully loaded :	-(" ;
        sleep 1
    fi
fi
	
if [ $bs = yes ] ; then
  #/usr/sbin/fbtruetype -x $text_x -y $text_y -t $text_color -s $text_size "SCSI modules set up!"
  echo "show 23000" > /proc/splash
fi

##############################################
#     Detect & load PCI modules              #
##############################################
	
get_pci_modules () {
       while read IGNORE ID IGNORE
       do
               VENDOR=`echo $ID | cut -b1-4`
               DEVICE=`echo $ID | cut -b5-8`
               DEVENTRY=`echo 0x0000${VENDOR} 0x0000${DEVICE}`
               cat /lib/modules/`uname -r`/*.pcimap | grep "$DEVENTRY" | cut -d ' ' -f1
       done
}
	
for MODULE in `get_pci_modules < /proc/bus/pci/devices | sort -u`
do echo Loading module $MODULE
       modprobe -s $MODULE
done 

##############################################
#     Detect & load ISA modules              #
##############################################
	
get_isapnp_modules () {
   while read IGNORE ID IGNORE
       do
         DEVICE="0x"`echo $ID | cut -b6-7``echo $ID | cut -b4-5`
         cat /lib/modules/`uname -r`/modules.isapnpmap | grep "^[^ ][^ ]*  *[^ ][^ ]*  *$DEVICE " | cut -f 1 -d " "
       done
}

for MODULE in `get_isapnp_modules < /proc/bus/isapnp/devices | sort -u`
do echo Loading module $MODULE
       modprobe $MODULE
done
				
if [ $bs = yes ] ; then
  #/usr/sbin/fbtruetype -x $text_x -y $text_y -t $text_color -s $text_size "Modules loaded!"
  echo "show 28000" > /proc/splash
fi

############################
## Mounting MoviX CD...
###############
for drive in /dev/cdroms/*      ;
  do
    echo "Attempting to finding MoviX cdrom in $drive"
    if ! mount -r -t iso9660 -o utf8  $drive /cdrom ;
     then
       continue
    else
       if [ -e /cdrom/movix/rc.movix ] ;
          then
            echo "Found MoviX cd in $drive!"
	    cp -a /cdrom/movix/rc.movix /etc/rc.d
	    chmod a+x /etc/rc.d/rc.movix
	    break
       else
            umount /cdrom
            continue
       fi
    fi
done

#######################################
# Checking that everything went ok
###############
if [ ! -e /etc/rc.d/rc.movix ]
 then

 	echo "verbose" > /proc/splash

                cat <<ALAS

Sorry, either the MoviX script could not load your
MoviX CD or an important movix script is missing.
In any case MoviX can't go on :-(

Possible explanations for this failure can be:
	
- You have too little RAM (less than about 40 MB).
- You have an unusual or non-standard CD-ROM drive (especially on certain
  laptops, which require you to pass parameters to the kernel at boot time).
- You have a corrupt or damaged CD-ROM image.

If you believe that your system should be supported and you do not
understand why you are seeing this message, you may ask for help
on the MoviX Help Forum.
Please visit

        http://movix.sf.net/

for more information.

ALAS
	sleep 10

	# Create a fake /usr/local/bin/mixer.pl so we don't get the stupid
	# "Bummer, couldn't find..." message from init
	echo "#! /bin/sh
		echo 'mixer.pl not found because the eMoviX CD could not be mounted'
		sleep 2400" > /usr/local/bin/mixer.pl
	chmod 755 /usr/local/bin/mixer.pl
fi

###################################################
# Set up UTF-8 mode on the console
###################################################
gunzip /usr/share/consolefonts/LatArCyrHeb-14.psf.gz
#doesn't work: dumpkeys | loadkeys --unicode > /dev/null
kbd_mode -u
consolechars --font=/usr/share/consolefonts/LatArCyrHeb-14.psf
/bin/echo -n -e '\033%G'

###################################################
##  Finally we can start interesting stuff...
##########
chmod a+x /etc/rc.d/rc.movix
/etc/rc.d/rc.movix
