#! /bin/bash

# Get the calling user's ID
userid=`id -u`

# Copy to /tmp or whatever the second argument is
if [ "X$1" = "X-t" ]; then
	if [ "X$2" = "X" ]; then
		tmpdir=/tmp
	else
		tmpdir="$2"
	fi
	echo "Copying movix-build.img to $tmpdir..."
	mv movix-build.img movix-build.img.ori
	cp movix-build.img.ori "$tmpdir"
	ln -s "$tmpdir/movix-build.img.ori" movix-build.img
fi

if [ "$userid" = "0" ]; then
# don't run as root
	echo "Please don't run this as root. It is not necessary but could cause problems."
	exit 1
elif echo "$userid" | egrep --silent '^[0-9]+$' ; then
	echo "Found user id $userid."
else
# Problems determining the numeric user id
	echo "Couldn't determine your user ID. It's possible that you will have problems."
	sleep 5
fi

mkdir -p movix-work
nice linux \
	devfs=nomount \
	ubd0=movix-build.img \
	umid=movix-build \
	eth0=tuntap,,,127.0.2.211 \
	mem=128m \
	external_user="$userid" \
	con1=xterm con2=/dev/null con3=/dev/null con4=/dev/null con5=/dev/null con6=/dev/null 

# Clean up
if [ "X$1" = "X-t" ]; then
	rm movix-build.img
	mv movix-build.img.ori movix-build.img
	rm "$tmpdir/movix-build.img.ori"
fi

