/*
 * Copyright 1998-2003 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2003 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * VIA, S3 GRAPHICS, AND/OR ITS SUPPLIERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
#include "debug.h"
#include "lcd.h"
#include "chip.h"
#include "share.h"

// extern function
extern int i2cWriteByte(u8 slave_addr, u8 index, u8 data);
extern int i2cReadByte(u8 slave_addr, u8 index, u8 *pData);
extern void set_output_path(int device, int set_iga, int output_interface);
extern void fill_crtc_timing(struct crt_mode_table *crt_table, int mode_index, int bpp_byte, int set_iga);
extern void write_reg_mask(u8 index, int io_port, u8 data, u8 mask);


// extern struct
extern struct chip_information  	    chip_info;
extern struct lvds_setting_information	lvds_setting_info;

int lvds_register_read(int index);

int check_lvds_chip(int device_id_subaddr, int device_id)
{
    if (lvds_register_read(device_id_subaddr) == device_id)
        return(OK); 
    else
        return(FAIL);
}

void init_lcd_size(void)
{
    switch(lvds_setting_info.get_lcd_size_method) {
        case GET_LCD_SIZE_BY_SYSTEM_BIOS:
            break;
        case GET_LCD_SZIE_BY_HW_STRAPPING:
            break;
        case GET_LCD_SIZE_BY_VGA_BIOS:
            break;
        //default:
            // GET_LCD_SIZE_BY_VGA_BIOS              
    }
     
}

int lvds_trasmitter_identify(void)
{
    chip_info.lvds_chip_info.lvds_chip_name = VT1631_LVDS;
    chip_info.lvds_chip_info.lvds_chip_slave_addr = VT1631_LVDS_I2C_ADDR;
    
    if (check_lvds_chip(VT1631_DEVICE_ID_REG, VT1631_DEVICE_ID)!= FAIL)
    {
        DEBUG_MSG(KERN_INFO "\n VT1631 LVDS ! \n");  	    
	    DEBUG_MSG(KERN_INFO "\n %2d", chip_info.lvds_chip_info.lvds_chip_name);
	    DEBUG_MSG(KERN_INFO "\n %2d", chip_info.lvds_chip_info.lvds_chip_name);
        return(OK);  
    }
        
   
    chip_info.lvds_chip_info.lvds_chip_name = NON_LVDS_TRANSMITTER;
    chip_info.lvds_chip_info.lvds_chip_slave_addr = VT1631_LVDS_I2C_ADDR;      
    return(FAIL);
} 

void lvds_register_write(int index, u8 data)
{
    u8  tmp;
    
    tmp = chip_info.tv_chip_info.tv_chip_on_slot;
    
    chip_info.tv_chip_info.tv_chip_on_slot = TV_ON_AGP;
            
    i2cWriteByte(chip_info.lvds_chip_info.lvds_chip_slave_addr, index, data);
    
    chip_info.tv_chip_info.tv_chip_on_slot = tmp;
    
}  

int lvds_register_read(int index)
{
    u8 data;
    int status;
    u8  tmp;
    
    tmp = chip_info.tv_chip_info.tv_chip_on_slot;
    
    chip_info.tv_chip_info.tv_chip_on_slot = TV_ON_AGP;
    status = i2cReadByte((u8)chip_info.lvds_chip_info.lvds_chip_slave_addr, (u8)index, &data);    
    
    chip_info.tv_chip_info.tv_chip_on_slot = tmp;
    return(data);
}

/* LCD Set Mode */
void lcd_set_mode(struct crt_mode_table *lcd_crt_timing, int video_index, int mode_bpp, int set_iga)
{
    fill_crtc_timing(lcd_crt_timing, video_index, mode_bpp/8, set_iga);
    set_output_path(DEVICE_DVI, set_iga, chip_info.tmds_chip_info.output_interface);  
}
