/*
 *
 *   Copyright (c) International Business Machines  Corp., 2000
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
*/ 
#ifndef _LINUX_JFS_FS_H
#define _LINUX_JFS_FS_H

#include <linux/version.h>

/* JFS magic number */

#define JFS_SUPER_MAGIC 0x3153464a /* "JFS1" */


#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,0)
	/* The entry point for a VFS */

	extern struct super_block *jfs_read_super (struct super_block *,
						   void *, int);
	extern int init_jfs_fs(void);

#ifdef _JFS
	#define kern22
	#if LINUX_VERSION_CODE > KERNEL_VERSION(2,2,13)
		#define event global_event
	#endif
	#if ( LINUX_VERSION_CODE < KERNEL_VERSION(2,2,18)) || !defined(__i386__)
	#define set_current_state(x) current->state = x
	#define BUG() panic("kernel BUG at %s:%d!\n", __FILE__, __LINE__)
	#endif
#endif /* _JFS */
#endif

#endif /* _LINUX_JFS_FS_H */
