/*
 *   Copyright (c) International Business Machines  Corp., 2000
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
#ifndef	_H_JFS_EXTENT
#define _H_JFS_EXTENT

/*  get block allocation allocation hint as location of disk inode */
#define	INOHINT(ip)	\
	(addressPXD(&((ip)->i_jfs_ixpxd)) + lengthPXD(&((ip)->i_jfs_ixpxd)) - 1)

int32	extAlloc(struct inode *, int64, int64, xad_t *, boolean_t);
int32	extFill(struct inode *, xad_t *);
int32	extHint(struct inode *, int64, xad_t *);
int32	extRealloc(struct inode *, int64, xad_t *, boolean_t);
int32	extRecord(struct inode *, xad_t *);

#endif	/* _H_JFS_EXTENT */
