/*
 *   Copyright (c) International Business Machines  Corp., 2000
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   MODULE_NAME:		xfsck.h
 *
 *   COMPONENT_NAME: 	jfschk
 *
 *	common data & function prototypes
 *
 *
 */

#ifndef _FSCK_BASE_H_
#define _FSCK_BASE_H_

/*

   --------- Defines and typedefs shared among the fsck modules ---------

*/

#define ISDIR(m)         (((m)&(IFMT)) == (IFDIR))
#define ISREG(m)         (((m)&(IFMT)) == (IFREG))
#define ISLNK(m)         (((m)&(IFMT)) == (IFLNK))
#define ISBLK(m)         (((m)&(IFMT)) == (IFBLK))
#define ISCHR(m)         (((m)&(IFMT)) == (IFCHR))
#define ISFIFO(m)        (((m)&(IFMT)) == (IFFIFO))


/* + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + +
 *
 * miscellaneous types used by fsck
 */
typedef int64    agg_byteidx_t;
typedef int64    fsblkidx_t;
typedef uint32   inoidx_t;
typedef uint64   long_idx_t;
typedef int64    mappgidx_t;
typedef uint32   reg_idx_t;
typedef int32    iagno_t;


/* + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + +
 * some useful constants
 */
#define BYTESPERPAGE      4096
#define log2BYTESPERPAGE  12
#define BITSPERPAGE       (4096*8)
#define log2BITSPERPAGE   15
#define BITSPERDWORD      32
#define log2BITSPERDWORD  5
#define BYTESPERDWORD     4
#define log2BYTESPERDWORD 2
#define BITSPERBYTE       8
#define log2BITSPERBYTE   3
#define MEMSEGSIZE        (64*1024)
#define log2BYTESPERKBYTE 10


/*
 * a doubleword bitmap
 */
typedef uint32 fsck_dword_bitmap_t;
/*
 * a mask for referencing the bits in a doubleword
 */
typedef uint32 fsck_dword_bitmask_t;

typedef fsck_dword_bitmap_t  *fsck_bitmap_ptr;
typedef fsck_dword_bitmask_t *fsck_bitmask_ptr;


#endif
