%define jfs_version 0.1.6
%define jfs_source jfs-%{jfs_version}-patch.tar.gz

Summary: IBM JFS utility programs
Name: jfsprogs
Version: %{jfs_version}
Release: 1
Copyright: GPL
Buildroot: /var/tmp/%{name}-buildroot
Group: System Environment/Base
Source: http://www10.software.ibm.com/developer/opensource/jfs/project/pub/%{jfs_source}

%description
Utilities to manage JFS filesystems

%prep
rm -rf jfs-%{version}
mkdir jfs-%{version}
tar -O -xzvf %{_sourcedir}/%{jfs_source} jfs-common-v%{version}-patch | patch -p1 -d jfs-%{version}

%build
make -C jfs-%{version}/fs/jfs/utils

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/sbin
mkdir -p $RPM_BUILD_ROOT/usr/man/man1 $RPM_BUILD_ROOT/usr/man/man8
install -s jfs-%{version}/fs/jfs/utils/output/* $RPM_BUILD_ROOT/sbin
cp jfs-%{version}/fs/jfs/utils/*/*.1 $RPM_BUILD_ROOT/usr/man/man1
cp jfs-%{version}/fs/jfs/utils/*/*.8 $RPM_BUILD_ROOT/usr/man/man8

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc jfs-%{version}/Documentation/filesystems/jfs.txt
/sbin
/usr/man

%changelog
* Sat Nov 18 2000 Jim Nance <jlnance@intrex.net>
- Built initial spec file
