/*
            
     FLAG.    -
    PACK.   .  PROTINB
       ,    
          
   UNPACK.      
    . INB (  .) 
             .
   PROTINB...

        (!)
   . ;) , ,   ...
*/

#include <stdio.h>
#include <syslog.h>
#include <signal.h>
#include <unistd.h>
#include <fcntl.h>	//   creat(2)
#include <string.h>	//   str*()
#include <sys/types.h>
#include <sys/param.h>
#include <sys/resource.h>
#include <sys/wait.h>
#include <sys/stat.h>
#if defined (BSD) && !_POSIX_SOURCE
	#include <sys/dir.h>
	typedef struct direct Dirent;
#else
	#include <dirent.h>
	typedef struct dirent Dirent;
#endif
#include "config.h"
#include "version.h"

main (int argc, char **argv)
{
	int pid;
	int status;
	int fd;
	int FPID;
	int d;
	int dd;
	int psec;
	struct rlimit	flim;
	DIR *dp;
	struct dirent *de;
	char *file;
	char pack[255];
	char unpack[255];
	char ticprog[255];
	char spid[6];

	//     
	if (getppid() !=1) {
		signal (SIGTTOU, SIG_IGN);
		signal (SIGTTIN, SIG_IGN);
		signal (SIGTSTP, SIG_IGN);
		if (fork() != 0)
			exit(0);
		setsid();
	}
	getrlimit (RLIMIT_NOFILE, &flim);
	for (fd = 0; fd < flim.rlim_max; fd++)
		close(fd);
	chdir("/");

	//---------------------------------------------------------------------

	//   PID-.    - .
	if((access(PID, F_OK)) == 0) {
		openlog("tossd", LOG_CONS, LOG_DAEMON);
		syslog(LOG_ERR, "Error! PidFile %s exist. I'm die!", PID);
		closelog();
		exit(1);
	}

	//  PID-   ...
	FPID = open (PID, O_WRONLY | O_CREAT, 0600);
	sprintf (spid, "%d", getpid());
	write (FPID, spid, strlen(spid));
	close (FPID);

	//--------------------------------------------------------------------

	openlog("tossd", LOG_PID | LOG_CONS, LOG_DAEMON);
	syslog(LOG_INFO, "experimental test %d.%d-%s",VER, SUBVER, DATE);
	closelog();

	//     PACK, UNPACK  TICPROG
	if((access(PACK, F_OK)) == -1) {
		openlog("tossd", LOG_PID | LOG_CONS, LOG_DAEMON);
		syslog(LOG_ERR, "Error! File %s don't exist. I'm die!", PACK);
		closelog();
		exit(1);
	}

	if((access(UNPACK, F_OK)) == -1) {
		openlog("tossd", LOG_PID | LOG_CONS, LOG_DAEMON);
		syslog(LOG_ERR, "Error! File %s don't exist. I'm die!", UNPACK);
		closelog();
		exit(1);
	}

	if((access(TICPROG, F_OK)) == -1) {
		openlog("tossd", LOG_PID | LOG_CONS, LOG_DAEMON);
		syslog(LOG_ERR, "Error! File %s don't exist. I'm die!", TICPROG);
		closelog();
		exit(1);
	}

	if (!(dp=opendir(PROTINB))) {
		openlog("tossd", LOG_PID | LOG_CONS, LOG_DAEMON);
		syslog(LOG_ERR, "Error opening directory %s. I'm die!", PROTINB);
		closelog();
		exit(1);
	}
	closedir(dp);

	chdir(PROTINB);	//   prot-inb -

	//   [un]pack     ticprog  
	sprintf(pack, "%s %d %s %s", NICEBIN, NICE, PACK, IFCONFIG);
	sprintf(unpack, "%s %d %s %s", NICEBIN, NICE, UNPACK, IFCONFIG);
	sprintf(ticprog, "%s %d %s %s", NICEBIN, NICE, TICPROG, TICFLAG); 
	
	psec = 0;	//   
	//  
	while (1)
	{
		sleep(SEC); // "" SEC 

		if ( psec++ == PSEC )
		{
			system (pack);	//   PACK
			psec = 0;	//  
		}

		//  -   ?
		dd = 0;
		do
		{
			sleep(1); //  86400  = 24 !
			if (!(dp=opendir(PROTINB)))
				dd++;
			else
				break;
		}
		while ( dd != 86400 );
		if ( dd == 86400 && !(dp=opendir(PROTINB)) ) {
		    openlog("tossd", LOG_PID | LOG_CONS, LOG_DAEMON);
		    syslog(LOG_ERR, "Error open directory %s. I'm die!", PROTINB);
		    closelog ();		
		    exit (0);
		}

		//   pkt-  listing -
		fileindir();
		
		//          12 ?
		//     
		rewinddir(dp);	// .  . .  
		while (de = readdir(dp))
			if ((strlen(de->d_name) == 12) &&
			((strncasecmp(de->d_name+8,".s",2) == 0) ||
			 (strncasecmp(de->d_name+8,".m",2) == 0) ||
			 (strncasecmp(de->d_name+8,".t",2) == 0) ||
			 (strncasecmp(de->d_name+8,".w",2) == 0) ||
			 (strncasecmp(de->d_name+8,".f",2) == 0) ||
			 (strncasecmp(de->d_name+8,".pkt",4) == 0)))
			// !   UNPACK
			{
					file = de->d_name;
					filesize(file);
					system (unpack);
			}
		//    tic -
		rewinddir(dp);	// .  . .  
		while (de = readdir(dp))
			if ((strlen(de->d_name) == 12) &&
		(strncasecmp(de->d_name+8,".tic",4) == 0))
				system (ticprog);
		dd = 0;
		do
		{
			d = closedir(dp);
			dd++;
			sleep(1);
		}
		while ( d == -1 && dd != 61 );
		if ( d == -1 || dd == 61 ) {
			// !  61     !
			openlog("tossd", LOG_PID | LOG_CONS, LOG_DAEMON);
			syslog(LOG_ERR, "Error close directory %s", PROTINB);
			closelog();		
			exit(0);
		}		
	}

}

//   = 0 - !
filesize(char *file)
{
	struct stat statv;
	int size;
	if ( stat(file, &statv) )
//	{
//		openlog("tossd", LOG_PID | LOG_CONS, LOG_DAEMON);
//		syslog(LOG_ERR, "Unknown error - file: %s", file);
//		closelog();
		return 1;	//   -  .  
//	}
	if ( statv.st_size ==0 )
	{
		openlog("tossd", LOG_PID | LOG_CONS, LOG_DAEMON);
		syslog(LOG_ERR, "Killing file: %s, size=0!", file);
		closelog();
		remove (file);	//   0- !
	}
}

//  INB -   pkt-  listing -
fileindir()
{
	char *file;
	char file1[255], file2[255];
	DIR *dir;
	struct dirent *dirp;
	dir = opendir(INB);
	while (dirp = readdir(dir))
		if ((strlen(dirp->d_name) == 12) &&
			(strncasecmp(dirp->d_name+8,".pkt",4) == 0))
			{
			     file = dirp->d_name;
			     openlog("tossd", LOG_PID | LOG_CONS, LOG_DAEMON);
			     syslog(LOG_ERR, "Found file %s in unprotected directory!", file);
			     closelog();
			     sprintf(file1, "%s/%s", PROTINB, file);
			     sprintf(file2, "%s/%s", INB, file);
			     if (rename(file2, file1) == -1) {
				     closedir(dir);
				     return 1;
			     }
			}
	closedir(dir);
	return 0;
}
