/*		   spool/queue -			*/

#include <stdio.h>
#include <string.h>
#include <sys/stat.h>	//  FreeBSD 3.0    ...
#include <dirent.h>
#include "limits.h"
#include "areafix.h"
#include "scandir.h"
#include "readconf.h"
#include "lib.h"
#include "log.h"

/*  : 1 -  , 0 -   */
int ScanDir(char *file)
{
	DIR *d;
	struct dirent *dp;
	int rc=0;

	log( 5, "Scaning queue directory: \"%s\"", QUEUE );

	if( ( d = opendir( QUEUE ) ) == NULL )
	{
		log( 0, "QueueDirectory \"%s\" cannot be opened! Exit", QUEUE );
		exit( -1 );
	}

	while( dp = readdir( d ) )
		if( ( strlen(dp->d_name) >= 10 ) )
		{
			strcpy( file, dp->d_name );
			rc = 1;
		}

	closedir( d );

	if( rc != 0 )
	{
		log( 4, "Found QueueFile \"%s/%s\"!", QUEUE, file );
	}
	return( rc );
}

/*  : 1 -  , 0 -   */
int ScanDirAutoCreate(char *file)
{
	DIR *d;
	struct dirent *dp;
	int rc=0;
	char dir[CHAR_MAX];

	snprintf( dir, PATH_MAX, "%s/%s", conf.Articles,
			conf.AutoCreateNewsGroup );
	log( 5, "Scaning AutoCreate \"%s\" directory.", dir );

	if( ( d = opendir( dir ) ) == NULL )
	{
		log( 0, "AutoCreate \"%s\" directory cannot be opened!", dir );
		return( rc );
	}

	while( dp = readdir( d ) )
		if( strchr( dp->d_name, '.' ) == NULL )
		{
			strcpy( file, dp->d_name );
			rc = 1;
		}

	closedir( d );

	if( rc != 0 )
	{
		log( 4, "Found message \"%s/%s\" in AutoCreate directory!",
				dir, file );
	}
	return( rc );
}
