/*
 *     RestEcho      
 *   site'.
 */

#include <stdio.h>
#include <string.h>
#include "limits.h"
#include "lib.h"
#include "readconf.h"
#include "readpasswd.h"
#include "log.h"

/*	 -1       	*
 *	. 0 - 					*/
int Restricted(char *Echo)
{
	FILE *f;
	char NewsGroup[CHAR_MAX];
	char str[CHAR_MAX];
	char *tmp;

	if( ( f = fopen( conf.RestEcho, "r" ) ) == NULL )
	{
		log( 5, "RestEcho file \"%s\" don't exist!", conf.RestEcho );
		//     -   !
		return( 0 );
	}

	//      Echo ( '+', '-', '%' )
	Echo += strspn( Echo, "%+-" );

	while( fgets( str, CHAR_MAX, f ) != NULL )
	{
		if( str[0] != '#' )
		{
			//  , 
			strtok( str, "\n" );
			sscanf( str, "%[A-Za-z0-9*._-]", NewsGroup );

			tmp = str;
			tmp += strcspn( tmp, " \t" );
			tmp += strspn( tmp, " \t" );

			strlwr( Echo );
			strlwr( NewsGroup );

			log(5,"Read RestEcho: \"%s\" \"%s\"",NewsGroup,tmp);

			//      .
			strtok( NewsGroup, "*" );

			if(strncmp( Echo, NewsGroup, strlen( NewsGroup))==0)
			{
		//   -    site'   !
		//     -    - 
		//  "" ,    -   
		// !
	
			   //  , ..    .

			   log( 5, "Find Echo \"%s\"", Echo );
			   log( 5, "Address \"%s\", restricted address \"%s\"",
					passwd.addr, tmp );

			   if( strchr( tmp, '*' ) == NULL )
			   {
				//   .
				if( strcmp( passwd.addr, tmp ) == 0 )
				{
					//     !
					log( 3, "Site \"%s\" cannot subscribe to \"%s\"",
							passwd.site, Echo );
					return( -1 );
				}
			   }
			   else
			   {
				//  .
				tmp += strspn( tmp, "*" );
				//    site'  !
				if( strstr( passwd.addr, tmp ) != NULL )
				{
					//       !
					log( 3, "Site \"%s\" cannot subscribe to \"%s\"",
							passwd.site, Echo );
					return( -1 );
				}
			   }

			   //      !
			   log( 3, "Site \"%s\" may be subscribed to \"%s\"",
					passwd.site, Echo );
			}
		}
	}

	fclose( f );
	log( 3, "Echo \"%s\" not found in RestEcho file to site \"%s\"!",
			Echo, passwd.site );
	return( 0 );
}
