/*
 *
 */

#include <stdio.h>
#include <string.h>
#include "limits.h"
#include "lib.h"
#include "readconf.h"
#include "readpasswd.h"
#include "areafix.h"

/*	patched by Kostya_Timoshenko@f523.n50.z2.fidonet.org		*/
int ReadPasswdFile(char *Name, char *Addr, char *Pass)
{
	FILE *f;
	int i=0;
	char buf[CHAR_MAX];

	if( ( f = fopen( conf.PasswdFile, "r" ) ) == NULL )
	{
		log( 0, "Error! PasswdFile don't exist!" );
		return( -1 );
	}
	while( fgets( buf, CHAR_MAX, f ) != NULL )
	{
		if( strlen( buf ) > 2 && buf[0] != '#' )
		{
			sscanf(buf,"%[A-Za-z0-9.@-]:%[A-Za-z0-9.@-]:%[A-Z-a-z0-9,]:%[A-Za-z0-9-.,@#%&*!+=<>_]",
			  &passwd.addr, &passwd.site,
			  &passwd.distr, &passwd.pass );

			log( 5, "Read PasswdFile: site \"%s\"",
					passwd.site );

#ifdef	PASSLWR
			strlwr( passwd.pass );
#endif

			if( strcmp( passwd.addr, Addr ) == 0 &&
				strcmp( passwd.pass, Pass ) == 0 )
			{
				log( 4,"Address \"%s\" found in PasswdFile",
					Addr );
				strcpy( passwd.name, Name );
				return( 0 );
			}
			i++;
		}
	}

	log( 4, "Address \"%s\" not found in PasswdFile", Addr );

	return( -1 );
}
