/*
 *
 */

#include <stdio.h>
#include <unistd.h>
#include "limits.h"
#include "readconf.h"
#include "readareas.h"
#include "readpasswd.h"
#include "readnewsfeeds.h"
#include "areafix.h"
#include "lib.h"

int GRP;		//  NewsGroup

void StrNewsGroup(char *str);
void Str(char *str, char *tmp);

/*     newsfeeds.					*
 *  :							*
 * -1	-	     (  newsfeeds  ..)	*
 *  0	-	Newsgroup'  				*/
int ReadNewsFeeds(char *Site)
{
	FILE *f, *ff;
	char str[CHAR_MAX];
	char PassiveSite[CHAR_MAX];
	char ReadStr[CHAR_MAX];

	snprintf( PassiveSite, CHAR_MAX, "#PASSIVE!#%s", Site );

	if( ( f = fopen( conf.NewsFeeds, "r" ) ) == NULL )
	{
		log( 0, "NewsFeeds \"%s\" don't exist!", conf.NewsFeeds );
		return( -1 );
	}

	GRP=0;

	site.passive = 0;

	//  
	while( fgets( str, CHAR_MAX, f ) != NULL )
	{
		if( strstr( str, PassiveSite ) != 0 )
		{
			site.passive = 1;
			goto Found;
		}
		else if( strstr( str, Site ) != 0 )
			goto Found;
	}
	fclose( f );

	//  -  DefaultNewsGroup  - 
	//   NewsFeeds
	if( conf.DefaultNewsGroup[0] == 0 )
		return( 1 );	// 1 -     NewsFeeds 

	//  conf.NewsFeeds  NEWNEWSFEEDS
	if( copy( conf.NewsFeeds, NEWNEWSFEEDS ) == -1 )
		return( 1 );	//    -  

	//  NEWNEWSFEEDS  
	if( ( f = fopen( NEWNEWSFEEDS, "a" ) ) == NULL )
	{
		log( 0, "NewNewsFeeds \"%s\" cannot be opened!", NEWNEWSFEEDS );
		fclose( f );
		exit( -1 );
	}

	//    NewsFeeds
	fprintf( f, "#\n%s\\\n\t:!*,\\\n\t%s\\\n\t/%s\\\n\t:%s:\n",
	  Site, conf.DefaultNewsGroup, conf.DefaultDistrib, conf.DefaultFlags );

	//  
	fclose( f );

	//   -1 -   NewsFeeds !
	return( -1 );

Found:
	while( fgets( str, CHAR_MAX, f ) != NULL )
	{
		if( strpbrk( str, "/" ) == 0 )
			StrNewsGroup( str );
		else goto Exit;
	}

Exit:
	fclose( f );
	site.numgroup = GRP;
	return( 0 );
}

/*			  				*/
void StrNewsGroup(char *str)
{
	char *ptr;

	strtok( str, "\\\n" );		//    '\'
	str += strspn( str, " \t#:" );	//   
	// str  .    .

	//     ','
	for( ; ptr = (char*)strtok( str, "," ); str = 0 )
		if( strcmp( ptr, "!*" ) != 0 )
		{
			strcpy( site.ng[GRP], ptr );
			log( 5, "Read SubScribe NewsGroup[%d]: \"%s\"",
					GRP, site.ng[GRP++] );
		}
}


/*	 newsgroup  NewsFeeds					*/
/*	patched by Kostya_Timoshenko@f523.n50.z2.fidonet.org		*/
int WriteNewsFeeds(char *Site)
{
	FILE *f, *ff;
	int i=-1;
	char str[CHAR_MAX];
	char tmp[CHAR_MAX];
	char PassiveSite[CHAR_MAX];

	snprintf( PassiveSite, CHAR_MAX, "#PASSIVE!#%s", Site );

	//   NewsFeeds  !
	if( ( f = fopen( conf.NewsFeeds, "r" ) ) == NULL )
	{
		log( 0, "NewsFeeds \"%s\" don't exist!", conf.NewsFeeds );
		return( -1 );
	}

	if( ( ff = fopen( NEWNEWSFEEDS, "w" ) ) == NULL )
	{
		log( 0, "NewNewsFeeds \"%s\" cannot be opened!",
				NEWNEWSFEEDS );
		fclose( f );
		exit( -1 );
	}

	//  
	while( fgets( str, CHAR_MAX, f ) != NULL )
	{
		if( strstr( str, PassiveSite ) != 0 )
			goto Found;
		else if( strstr( str, Site ) != 0 )
			goto Found;
		fputs( str, ff );
	}
	fclose( f );
	return( -1 );

Found:	//  .      !
	log( 5, "Site \"%s\" fount in the NewsFeeds file", Site );

	if( site.passive == 1 )
	{
		log( 4, "Site have \"passive\" status" );
		fprintf( ff, "#PASSIVE!#%s\\\n#\t:!*", Site );
	}
	else
	{
		log( 4, "Site have \"active\" status" );
		fprintf( ff, "%s\\\n\t:!*", Site );
	}

	while( ++i != areas.n )
	{
		//       newsgroup'?
		if( areas.s[i] == 1 )
		{
			// !
			//    passive  active.
			if( site.passive == 1 )
				//   passive!
				fprintf( ff, ",\\\n#\t%s", areas.ng[i] );
			else
				fprintf( ff, ",\\\n\t%s", areas.ng[i] );
			log( 5, "Write SubScribe NewsGroup[%d]: \"%s\"",
					i+1, areas.ng[i] );
		}
	}
	fprintf( ff, "\\\n" );

	log( 5, "Write %d NewsGroups", i );

	//    newsgroup',     
	//      NewsFeeds ,
	//  ,    - !
	while( fgets( str, CHAR_MAX, f ) != NULL )
	{
		if( strpbrk( str, "/" ) != 0 )
			//   !      
			//   NewsFeeds!
			goto Write;
	}
	// !    -   '-1'
	fclose( f );
	fclose( ff );

	exit( -1 );

Write:
	//   ,     '/\'
	//       '/\'

	Str( str, tmp );
	if( site.passive == 1 )
		fprintf( ff, "#%s", tmp );
	else
		fprintf( ff, "%s", tmp );

	if( fgets( str, CHAR_MAX, f ) != NULL );	//  '::'
	{
		Str( str, tmp );
		if( site.passive == 1 )
			fprintf( ff, "#%s", tmp );
		else
			fprintf( ff, "%s", tmp );
	}

	//     
	while( fgets( str, CHAR_MAX, f ) != NULL )
		fputs( str, ff );

	fclose( f );
	fclose( ff );

	log( 5, "Site write to the NewsFeeds file... OK!" );

	return( 0 );	//  !
}

void Str(char *str, char *tmp)
{
	// TODO -  tmp
	str += strspn( str, "#" );
	strcpy( tmp, str );
}
