/*
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "limits.h"
#include "lib.h"
#include "areafix.h"
#include "configcomm.h"
#include "readconf.h"
#include "areafix.h"

void ReadConfig(char *config)
{
	FILE *f;
	int c;
	char buf[CHAR_MAX];
	char comm[CHAR_MAX];
	char param[CHAR_MAX];

	/*				Default				*/
	strcpy( conf.DefaultNewsGroup, "" );	//   -  
	strcpy( conf.PostNewsGroup, "" );	//   -  
	conf.Forward = 0;			//   - No
	conf.SubScribeAll = 0;			//   - No
	/*	--------------------------------------------------	*/

	if( ( f = fopen( config, "r" ) ) == NULL )
	{
		log( 0, "Error! Config file don't exist!" );
		exit( -1 );
	}
	while( fgets( buf, CHAR_MAX, f ) != NULL )
	{
		if( strlen( buf ) > 2 && buf[0] != '#' )
		{
			sscanf( buf, "%s%*[ \t]%[A-Za-z0-9'`*.,#/%<>-+=_\()| ]",
					&comm, &param );
			c = FoundComm( comm );

			log( 5, "#%d Command/Param: \"%s\" \"%s\"",
					c, comm, param );

			switch( c )
			{
				case 0: strcpy( conf.SysOp, param );
					break;
				case 1: strcpy( conf.Address, param );
					break;
				case 2: strcpy( conf.Robot, param );
					break;
				case 3: strcpy( conf.UpLink_Robot, param );
					break;
				case 4: strcpy( conf.DefaultNewsGroup, param );
					break;
				case 5: strcpy( conf.DefaultDistrib, param );
					break;
				case 6: strcpy( conf.DefaultFlags, param );
					break;
				case 7: strcpy( conf.PasswdFile, param );
					break;
				case 8: strcpy( conf.HelpFile, param );
					break;
				case 9: strcpy( conf.NewsFeeds, param );
					break;
				case 10: strcpy( conf.NewsGroups, param );
					break;
				case 11: strcpy( conf.Active, param );
					break;
				case 12: strcpy( conf.Echo2News, param );
					break;
				case 13: strcpy( conf.RestEcho, param );
					break;
				case 14: strcpy( conf.MailCommand, param );
					break;
				case 15: strcpy( conf.ReloadCommand, param );
					break;
				case 16: strcpy( conf.DescrMissing, param );
					break;
				case 17: conf.LogLevel = atoi( param );
					break;
				case 18:
					if( tolower( param[0] ) == 'y' )
						conf.Forward = 1;
					else
						conf.Forward = 0;
					break;
				case 19: strcpy( conf.BadNewsGroup, param );
					 break;
				case 20: strcpy( conf.UplinkFile, param );
					 break;
				case 21: strcpy( conf.ForwardFile, param );
					 break;
				case 22: strcpy( conf.Articles, param );
					 break;
				case 23: strcpy(conf.AutoCreateNewsGroup,param);
					 strpath(conf.AutoCreateNewsGroup);
					 break;
				case 24: strcpy( conf.RmMsg, param );
					 break;
				case 25: conf.PathI = atoi( param );
					 break;
				case 26: strcpy( conf.NewGroup, param );
					 break;
				case 27: strcpy( conf.NewsCommand, param );
					 break;
				case 28: strcpy( conf.PostNewsGroup, param );
					 break;
				case 29:
					if( tolower( param[0] ) == 'y' )
						conf.SubScribeAll = 1;
					else
						conf.SubScribeAll = 0;
					break;
				default:
					log( 0, "Error Command \"%s\"", comm );
			}
		}
	}
}

int FoundComm(char *command)
{
	int i=0;
	while( i++ != MAXCONF )
	{
		strlwr( command );
		if( strcmp( command, CONFCOMM[i-1] ) == 0 )
			return( i-1 );
	}
	return( -1 );
}
