/*		    /etc/ifmail/Areas		*/

#include <stdio.h>
#include <string.h>
#include "limits.h"
#include "readconf.h"
#include "readareas.h"
#include "readpasswd.h"
#include "readnewsfeeds.h"
#include "areafix.h"

int ReadAreas();

int ReadActive()
{
	FILE *f;
	int i, ii=0;
	char buf[CHAR_MAX];
	char NewsGroup[CHAR_MAX];

	if( ReadNewsFeeds( passwd.site ) == -1 )
	{
		if( conf.DefaultNewsGroup[0] == 0 )
		{
			//      DefaultNewsGroup -
			//    ,   
			// NewsFeeds ___!
			SendErrorNewsFeeds();
			return( -1 );
		}
		//  NewsFeeds
		log( 5, "Exec: \"%s\"", conf.ReloadCommand );
		system( conf.ReloadCommand );
		//   NewsFeeds
		ReadNewsFeeds( passwd.site );
	}

	log( 4, "Site subscribe for %d newsgroups", site.numgroup );

	ReadAreas();

	if( ( f = fopen( conf.Active, "r" ) ) == NULL )
	{
		log( 0, "Error! Active file don't exist!" );
		exit( -1 );
	}

	//    active (inn)
	while( fgets( buf, CHAR_MAX, f ) != NULL )
	{
		sscanf( buf, "%[A-Za-z0-9_-+=.] %*", NewsGroup );

		log( 5, "Read ActiveFile newsgroup: \"%s\"", NewsGroup );

		//  NewsGroup  Echo2News -
		i = FoundAreas( NewsGroup );
		if( i != -1 && strstr( passwd.distr, "int" ) == NULL )
		{
		   //    
		   if( strstr( conf.BadNewsGroup, NewsGroup ) == NULL )
		   {

			log( 5,"NewsGroup \"%s\" may be subscribe",
					NewsGroup);

			if( i != -1 )
				// NewsGroup    active
				strcpy( areas.echo[ii], ar.echo[i] );
			else
				// NewsGroup     active
				strcpy( areas.echo[ii], NewsGroup );

			strcpy( areas.ng[ii], NewsGroup );
			strcpy( areas.distr[ii], ar.distr[i] );
			ReadNewsGroups( ii );	//  

			if( SiteSubScribe( NewsGroup ) == -1 )
			{
				log( 5, "Site don't subscibe on \"%s\"",
					NewsGroup );
				//      newsgroup
				areas.s[ii] = 0;
			}
			else
			{
				log( 5, "Site already subscribe on \"%s\"",
					NewsGroup );
				//     newsgroup
				areas.s[ii] = 1;
			}
			ii++;
		   }
		   else
			log( 4, "NewsGroup \"%s\" cannot be subscribe, see BadNewsGroup",
					NewsGroup );
		}
		else
			log( 4, "NewsGroup \"%s\" cannot be subscribe, see distributions \"int\"",
				NewsGroup );   
	}
	areas.n = ii;

	return( 0 );
}

//   Areas
int ReadAreas()
{
	FILE *f;
	int i=0;
	char buf[CHAR_MAX];
	char Ng[CHAR_MAX];

	if( ( f = fopen( conf.Echo2News, "r" ) ) == NULL )
	{
		log( 0, "Error! Echo2News file don't exist!" );
		return( -1 );
	}

	while( fgets( buf, CHAR_MAX, f ) != NULL )
	{
		if( strlen( buf ) > 2 && buf[0] != ' ' &&
			buf[0] != '#' && buf[0] != '*' &&
			strpbrk( buf, "ABCDEFGHIJKLMNOPQRSTUVWXYZ" ) != NULL )
		{
			sscanf(buf,"%[A-Z0-9!@#$%&_-+=.] %[A-Za-z0-9_-+=.] %[A-Za-z0-9]",
				&ar.echo[i],&ar.ng[i],&ar.distr[i] );

			if( strstr( passwd.distr, ar.distr[i] ) !=0 )
			{
				log(5,"Read Echo2News file: \"%s\" \"%s\" \"%s\"",ar.echo[i],ar.ng[i],ar.distr[i]);
			}
			i++;
		}
	}
	ar.n = i;
	fclose( f );
	return( 0 );
}

// :
// -1	-  NewsGroup    Echo2News
// NN	-   ar.ng  NewsGroup'
int FoundAreas(char *NewsGroup)
{
	int i=-1;

	while( ++i != ar.n )
		if( strcmp( ar.ng[i], NewsGroup ) == 0 )
			return( i );
	log( 4, "NewsGroup \"%s\" not found in Echo2News file", NewsGroup );
	return( -1 );
}

//   -     NewsGroup  .
// 0	- ;
// -1	-  .
int SiteSubScribe(char *NewsGroup)
{
	int i=0;

	while( i != site.numgroup )
		if( strcmp( site.ng[i++], NewsGroup ) == 0 )
			return( 0 );
	return( -1 );
}

//     NewsGroup
int ReadNewsGroups(int i)
{
	FILE *f;
	int n, m;
	char str[CHAR_MAX];
	char *tmp;
	char NewsGroup[CHAR_MAX];

	if( ( f = fopen( conf.NewsGroups, "r" ) ) == NULL )
	{
		log( 0, "Error! NewsGroup file don't exist!" );
		goto Missing;
	}

	while( fgets( str, CHAR_MAX, f ) != NULL )
	{
		//  , 
		strtok( str, "\n" );
		sscanf( str, "%[A-Za-z0-9._-]", NewsGroup );

		tmp = str;
		tmp += strcspn( tmp, " \t" );
		tmp += strspn( tmp, " \t" );

		if( strcmp( areas.ng[i], NewsGroup ) == 0 )
		{
			strcpy( areas.desc[i], tmp );
			fclose( f );
			return( 0 );
		}
	}

	fclose( f );

Missing: //  !
	strcpy( areas.desc[i], conf.DescrMissing );
	return( -1 );
}
