#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>
#include "limits.h"
#include "time.h"
#include "readconf.h"
#include "log.h"

#define	SHOW(s) fputs(s,logfile), cnt+=strlen(s)

/*
 *   Log -, : buf -  ,
 * level -  
 */
int log(int level, const char *format, ...)
{
	FILE *logfile;
	char TIME[CHAR_MAX];
	char *tokp, ifmt[CHAR_MAX], *hdr = ifmt, buf[CHAR_MAX];
	int cnt=0;
	va_list pa;

	strcpy(ifmt,format);	//    
	va_start(pa,format);	// pa -     

	if( level > conf.LogLevel ) return( 1 );
	loginit( TIME );
	if( ( logfile = fopen( LOGFILE, "a" ) ) == NULL ) exit( -1 );
	fprintf( logfile, "%s AreaFix[%d]: ", TIME, level);

	while( tokp=strchr(hdr,'%')) {	/*   "%" */
		*tokp++ = '\0';
		SHOW(hdr);		//    "%"
		if (strchr("dfgeisc%",*tokp)) { /* ,  
						    
						    */
			switch (*tokp) {
				case 'd':	// %i, %d
				case 'i':
					snprintf(buf,CHAR_MAX,"%i",
							va_arg(pa,int));
					break;
				case 's':	// %s
					strcpy(buf,va_arg(pa,char*));
					break;
				case 'c':	// %c
					buf[0] = va_arg(pa,char);
					buf[1] = '\0';
					break;
				case 'f':	// %f
					snprintf(buf,CHAR_MAX,"%f",
							va_arg(pa,double));
					break;
				case 'g':	// %g
					snprintf(buf,CHAR_MAX,"%g",
							va_arg(pa,double));
					break;
				case '%':	// %%
					strcpy(buf,"%");
					break;
			}
			SHOW(buf);	//   
		}
		else {				/*   . -
						        */
			fputc(*tokp,logfile);
			cnt++;
		}
		hdr = tokp + 1;
	}
	SHOW(hdr);		// ,   ,  
	va_end(pa);

	fprintf( logfile, "\n" );
	fclose( logfile );
	return( 0 );
}
