#include <stdio.h>
#include <ctype.h>
#include <locale.h>
#include "limits.h"
#include "lib.h"

/*     .				*/
/* (   !)					*/
char *strlwr(char *c)
{
	setlocale(LC_CTYPE,"");
	while( *c )
	{
		*c = tolower( *c );
		++c;
	}
}

/*	    (  0-9)			*/
/*	0 - , -1 - 						*/
int ifprint(int c)
{
	// 0-9
	if( c >= 48 && c <= 57 )
		return( -1 );
	// A-Z
	if( c >= 65 && c <= 90 )
		return( -1 );
	// a-z
	if( c >= 97 && c <= 122 )
		return( -1 );
	// '-'  '.'
	if( c == 45 || c == 46 )
		return( -1 );
	return( 0 );
}

/*	 __ 					*/
int copy(char *oldfile, char *newfile)
{
	FILE *f, *ff;
	char str[CHAR_MAX];

	//   -  
	if( ( f = fopen( oldfile, "r" ) ) == NULL )
		return( -1 );

	//   -  
	//   - ,    - .
	if( ( ff = fopen( newfile, "w" ) ) == NULL )
	{
		fclose( f );
		//  , ..    .
		remove( newfile );
		return( -1 );
	}

	//     
	while( fgets( str, CHAR_MAX, f ) != NULL )
		fputs( str, ff );

	//   
	fclose( f );
	fclose( ff );

	return( 0 );
}

/*	   '.'  '/'   str			*/
char *strpath(char *str)
{
	char *tmp;

	tmp = str;
	while( *str )
	{
		if( *str == '.' ) *str = '/';
		++str;
	}
	return tmp;
}

/*	     '_'   str		*/
char *strspace(char *str)
{
	char *tmp, *tmp_;

	strcpy( tmp, str );
	tmp_ = tmp;

	while( *tmp_ )
	{
		if( *tmp_ == ' ' ) *tmp_ = '_';
		++tmp_;
	}
	return tmp;
}
