/*
 * AutoCreate
 * Patch by Yarick Rastrigin <Yarick.Rastrigin@f17.n5025.z2.fidonet.org>
 * Patch by Stas Barmin <Stas.Barmin@f137.n5015.z2.fidonet.org>
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "limits.h"
#include "autocreate.h"
#include "readconf.h"
#include "readareas.h"
#include "readnewsfeeds.h"
#include "uplink.h"
#include "lib.h"
#include "log.h"
#include "areafix.h"

void NewNewsGroup(char *Echo);

int AutoCreate()
{
	FILE *f;
	int i, ii;
	char file[CHAR_MAX];
	char AutoCreateFile[PATH_MAX];
	char rmmsg[PATH_MAX];
	char str[CHAR_MAX];
	char Echo[CHAR_MAX];
	char Path[CHAR_MAX];
	char Site[CHAR_MAX];
	char Distr[CHAR_MAX];
	char *tmp;

	//    
	Uplink();

	//  AutoCreate    
	// .
	while( ScanDirAutoCreate( file ) != 0 )
	{
		snprintf( AutoCreateFile, PATH_MAX, "%s/%s/%s", conf.Articles,
			conf.AutoCreateNewsGroup, file );

		if( ( f = fopen( AutoCreateFile, "r" ) ) == NULL )
		{
			log(0,"\"%s\" cannot be opened! Error!",AutoCreateFile);
			snprintf( rmmsg, PATH_MAX, "%s %s",
					conf.RmMsg, AutoCreateFile );
			//  ,    !
			log( 5, "Exec: \"%s\"", rmmsg );
			system( rmmsg );
			fclose( f );
			return( -1 );
		}

		i=0; ii=0;
		while( fgets( str, CHAR_MAX, f ) != NULL )
		{
			if( strncmp( str, "Path: ", 6 ) == 0 )
			{
				//    "!"
				sscanf( str, "Path: %s", Path );
				log( 5, "Read \"Path: %s\"", Path );
				tmp = Path;
				while( i++ != conf.PathI )
				{
					tmp += strcspn( tmp, "!" );
					tmp++;
				}
				strtok( tmp, "!" );
				strcpy( Site, tmp );
				ii++;
			}
			else if( strncmp( str, "X-FTN-AREA: ", 12 ) == 0 )
			{
				//   : 'X-FTN-AREA: ECHO'
				sscanf( str, "X-FTN-AREA: %s", Echo );
				log( 5, "Read \"X-FTN-AREA: %s\"", Echo );
				ii++;
				break;	//    
			}
		}
		if( ii != 2 )
		{
			log( 0, "Error! Can't find 'Path:' or 'X-FTN-AREA:' string in \"%s\"!", AutoCreateFile );
			snprintf( rmmsg, PATH_MAX, "%s %s",
					conf.RmMsg, AutoCreateFile );
			log( 5, "Exec: \"%s\"", rmmsg );
			//  ,    !
			system( rmmsg );
			fclose( f );
		}
		else
		{
			//   
			ii = AutoCreateEcho( Site, Echo, Distr );
			if( ii == 0 || ii == 1 )
			{
				// TODO -     
				// ,  newsgroup   -
				// inn'   newsgroup
				// -  Distr !
				Post( Site, Echo, Distr, AutoCreateFile, ii );
				log( 2, "Message from: \"%s\", area: \"%s\".",
					Site, Echo );
			}
			snprintf( rmmsg, PATH_MAX, "%s %s",
					conf.RmMsg, AutoCreateFile );
			log( 5, "Exec: \"%s\"", rmmsg );
			//   .
			system( rmmsg );
			fclose( f );
		}
		/*		  NewsFeeds		*/
		remove( NEWNEWSFEEDS );
	}
	return( 0 );
}

/*		    			*/
int AutoCreateEcho(char *Site, char *Echo, char *Distr)
{
	FILE *f;
	int i=-1;
	char NewsGroup[CHAR_MAX];
	char str[CHAR_MAX];

	if( uplink.n == 0 )
	{
		log( 5, "Uplink not found - returned..." );
		return( -1 );
	}

	strcpy( NewsGroup, Echo );
	NewNewsGroup( NewsGroup );

	if( ( f = fopen( conf.Echo2News, "r" ) ) == NULL )
	{
		fclose( f );
		log( 0, "Error opened Echo2News file \"%s\"", conf.Echo2News );
		return( -1 );
	}

	//     
	while( fgets( str, CHAR_MAX, f ) != NULL )
	{
		// Stas Barmin <Stas.Barmin@f137.n5015.z2.fidonet.org>
		if( (strncmp( str, Echo, strlen( Echo ) ) == 0) &&
				( strcmp( Echo, str ) == -9 ||
				  strcmp( Echo, str ) == -32 ) ) // ?? tma
		{
			log( 5, "Area \"%s\" already exist!", Echo );
			fclose( f );
			return( 1 );
		}
	}
	fclose( f );

	while( ++i != uplink.n )
	{
		if( strcmp( uplink.Uplink[i], Site ) == 0 )
		{
			// 
			CreateArea( Site, NewsGroup, Echo, uplink.Distr[i] );
			strcpy( Distr, uplink.Distr[i] );
			return( 0 );
		}
	}
	log( 0, "Cannot create area from \"%s\"", Site );
	return( -1 );
}

int CreateArea(char *Site, char *NewsGroup, char *Echo, char *Distr)
{
	FILE *f;
	int i=-1;
	char str[CHAR_MAX];
	char path[PATH_MAX];

	if( ReadNewsFeeds( Site ) == -1 )
	{
		log( 0, "Cannot create area from \"%s\" (NewsFeeds error!)",
				Site );
		return( -1 );
	}

	//   Distr.NewsGroup
	snprintf( str, CHAR_MAX, "%s.%s", Distr, NewsGroup );

	//    _areas newsgroup',    site
	while( ++i != site.numgroup )
	{
		//   -    newsgroup?
		if( strcmp( site.ng[i], str ) == 0 )
		{
			log( 0, "Error! NewsGroup \"%s\" already exist - BUG!",
					str );
			return( -1 );
		}
		// uplink    newsgroup
		areas.s[i] = 1;
		//  newsgroup,    uplink  
		strcpy( areas.ng[i], site.ng[i] );
	}

	//     newsgroup.
	areas.s[i] = 1;
	strcpy( areas.ng[i], str );

	areas.n = i+1;	//    newsgroup;

	log( 5, "Write new newsgroup to areas.ng[%d]: \"%s\"",
			areas.n, areas.ng[i] );

	//   newsgroup  Echo2News
	snprintf( path, PATH_MAX, "%s.bak", conf.Echo2News );
	if( copy( conf.Echo2News, path ) == -1 )
		log( 0, "Cannot copy Echo2News \"%s\" to bak file!",
				conf.Echo2News );

	//  Echo2News  
	if( ( f = fopen( conf.Echo2News, "a" ) ) == NULL )
	{
		log( 0, "Cannot opened Echo2News \"%s\" file! Creating error!",
				conf.Echo2News );
		return( -1 );
	}

/*	   ,     -   ->	*/
	loginit( str );
	fprintf( f, "  AutoCreat(%s) by site \"%s\" at \"%s\"\n",
			VER, Site, str );
/*	^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^	 */

	//  'ECHO	newsgroup	distributions'
	fprintf( f, "%s\t%s.%s\t%s\n", Echo, Distr, NewsGroup, Distr );
	//   Echo2News
	fclose( f );

	//   newsgroup'
	snprintf( path, PATH_MAX, "%s %s.%s", conf.NewGroup, Distr, NewsGroup );
	log( 5, "Exec: \"%s\"", path );
	system( path );

	//   NewsFeeds
	WriteNewsFeeds( Site );

	//  inn',     NewsFeeds
	log( 5, "Exec: \"%s\"", conf.ReloadCommand );
	system( conf.ReloadCommand );
	return( 0 );
}

/*		     	*/
void NewNewsGroup(char *Echo)
{
	int c;

	strlwr( Echo );
	while( *Echo )
	{
		c = *Echo;
		if( ifprint( c ) == 0 )
			*Echo = '_';
		++Echo;
	}
}

/*		      newsgroup,	*
 *		    autocreate    	*/
int Post(char *Site, char *Echo, char *Distr, char *AutoCreateFile, int post)
{
	FILE *f, *ff;
	char str[CHAR_MAX];
	char NewsGroup[CHAR_MAX];
	char *nntpserver;

	strcpy( NewsGroup, Echo );
	NewNewsGroup( NewsGroup );

	//   -  
	if( ( f = fopen( AutoCreateFile, "r" ) ) == NULL )
		return( -1 );

	//   -  
	//   - ,    - .
	if( ( ff = fopen( TMPMAIL, "w" ) ) == NULL )
	{
		fclose( f );
		//  , ..    .
		remove( TMPMAIL );
		return( -1 );
	}

	//     
	while( fgets( str, CHAR_MAX, f ) != NULL )
	{
		if( strncmp( str, "Newsgroups: ", 12 ) == 0 )
			fprintf( ff, "Newsgroups: %s.%s\n", Distr, NewsGroup );
		//   'Xref:'  'Message-ID:'
		// Yarick Rastrigin <Yarick.Rastrigin@f17.n5025.z2.fidonet.org>
		else if ( strncmp( str, "Xref: ", 6 ) != 0 &&
				strncmp( str, "Message-ID: ", 12 ) != 0 )
			fputs( str, ff );
	}

	//   
	fclose( f );
	fclose( ff );

	if( PostNews() != 0 )
		return( -1 );

	//  PostNewsGroup  -     .
	if( conf.PostNewsGroup[0] == 0 || post == 1 )
		goto Exit;

	log( 4, "Posting message to \"%s\"", conf.PostNewsGroup );

	if( ( f = fopen( TMPMAIL, "w" ) ) == NULL )
	{
		log( 0, "Cannot be opened TMPMAIL \"%s\"", TMPMAIL );
		return( -1 );
	}
	fprintf( f, "From: %s <%s@%s>\n", conf.Robot, conf.Robot, conf.Address);
	fprintf( f, "Newsgroups: %s\n", conf.PostNewsGroup );
	fprintf( f, "Subject: New area creation notification\n\n\n" );
	// TODO -    FTN -. ( ?)
	fprintf( f, "Area %s created at %s by %s\n", Echo, conf.Address, Site);
	fclose( f );

	if( PostNews() != 0 )
		return( -1 );

Exit:
	remove( TMPMAIL );
	return( 0 );
}

/*		    NewsGroup'		*/
int PostNews()
{
	char comm[PATH_MAX];

	if( conf.NewsCommand[0] == '>' || conf.NewsCommand[0] == '|' )
	{
		snprintf( comm, PATH_MAX, "%s %s %s >/dev/null 2>/dev/null",
				CAT, TMPMAIL, conf.NewsCommand );
		log( 5, "Exec: \"%s\"", comm );
		system( comm );
	}
	else
	{
		log( 0, "Error NewsCommand \"%s\"", conf.NewsCommand );
		remove( TMPMAIL );
		return( -1 );
	}

	return( 0 );
}
