/************************************************************************
 * AreaFix (C) 1999, Maxim Timofeyev					*
 * NetMail:	2:5030/763.1						*
 * E-Mail:	tma@worldmailer.com					*
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "limits.h"
#include "whatcomm.h"
#include "readnewsfeeds.h"
#include "readconf.h"
#include "readpasswd.h"
#include "readmsg.h"
#include "sendmail.h"
#include "scandir.h"
#include "version.h"
#include "areafix.h"
#ifndef	HAS_AQUEUE
#include "queue.h"
#endif

#define	RUNMODE_HELP		1
#define	RUNMODE_MANAGER		2
#define	RUNMODE_AREAFIX		3
#define	RUNMODE_AUTOCREATE	4
#define	RUNMODE_PASSIVE		5
#define	RUNMODE_ACTIVE		6

int main(int argc, char *argv[])
{
	FILE *f;
	int ch, flg=0, sleep_=0;
	int runmode=RUNMODE_HELP;
	char Config[PATH_MAX];
/*	------------------------------------------------------------	*/
//	exit( -1 );
/*	------------------------------------------------------------	*/

	//    ...
	if( getuid() == 0 || geteuid() == 0 || getgid() == 0 || getegid() == 0 )
	{
		printf( "AreaFix CAN NOT run from root user/group\n" );
		return( -1 );
	}

	snprintf( Config, CHAR_MAX, "%s/config", CONFIGPATH );

	//  LOCK -
	while( ( access( LOCK, F_OK ) ) == 0 )
	{
		//  Lock -  -   !
		sleep( 1 );
		if( sleep_++ >= 600 )
			//     ,   10  - !
			exit( -1 );
	}
	if( ( f = fopen( LOCK, "w" ) ) == NULL ) return( -1 ); //  .
	fprintf( f, "%d\n", getpid() );
	fclose( f );

#ifndef	HAS_AQUEUE
	while( ( ch = getopt( argc, argv, "p:r:acmh" ) ) != EOF )
#else
	while( ( ch = getopt( argc, argv, "p:r:ach" ) ) != EOF )
#endif
	{
		switch( ch )
		{
			case 'p':	runmode=RUNMODE_PASSIVE; flg++; break;
			case 'r':	runmode=RUNMODE_ACTIVE; flg++; break;
			case 'a':	runmode=RUNMODE_AREAFIX; flg++; break;
			case 'c':	runmode=RUNMODE_AUTOCREATE; flg++; break;
#ifndef	HAS_AQUEUE
			case 'm':	runmode=RUNMODE_MANAGER; break;
#endif
			case 'h':	runmode=RUNMODE_HELP; break;
			case '?':	runmode=RUNMODE_HELP; break;
			default:	runmode=RUNMODE_HELP; break;
		}
		if( runmode != RUNMODE_HELP )
		{
			if( flg == 1 ) ReadConfig( Config );
#ifndef	HAS_AQUEUE
			if( runmode == RUNMODE_MANAGER ) aqueue();
#endif
			if( runmode == RUNMODE_AREAFIX ){ ver(); AreaFix(); }
			if( runmode == RUNMODE_AUTOCREATE ) AutoCreate();
//			if( runmode == RUNMODE_PASSIVE ){ver(); PassiveSite();}
//			if( runmode == RUNMODE_ACTIVE ){ ver(); ActiveSite(); }
		}
		else
			Help( argv[0] );
	}
	if( argc < 2 ) Help( argv[0] );
	//  Lock -
	remove( LOCK );
	return( 0 );
}

int Help(char *programm)
{
	printf("AreaFix %s-%s (C) Maxim Timofeyev. E-Mail: tma@worldmailer.com\n",VER,DATE);
	printf("Use: \"%s -<arg> <param>\"\n",programm);
	printf("arg:\n\t-p <address>\t- Make site '<address>' subscription %Passive;\n");
	printf("\t-r <address>\t- Make site '<address>' subscribtion %Resume;\n");
	printf("\t-a\t\t- AreaFix, no options;\n");
	printf("\t-c\t\t- AutoCreate, no options;\n");
#ifndef	HAS_AQUEUE
	printf("\t-m\t\t- Area Manager, no options;\n");
#endif
	printf("\t-h|?\t\t- Help.\n");
	return( 0 );
}

void RemoveQueueFile(char *QueueFile)
{
	char d[CHAR_MAX];
	/* End.  QueueFile					*/
	snprintf( d, CHAR_MAX, "%s/%s", QUEUE, QueueFile );

	if( remove( d ) == 0 )
	{
		log( 4, "Delete QueueFile \"%s/%s\"", QUEUE, QueueFile );
	}
	else
	{
		log( 0, "Error by deleted QueueFile \"%s/%s\"!",
			QUEUE, QueueFile );
	}
}

int AreaFix()
{
	char QueueFile[CHAR_MAX];
	/*  queue -    	*/
	while( ScanDir( QueueFile ) != 0 )
	{
		/*		 			*/
		ReadMsg( QueueFile );

		/*		  		*/
		RemoveQueueFile( QueueFile );

		/*		  NewsFeeds		*/
		remove( NEWNEWSFEEDS );
	}
	return( 0 );
}
