#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "ifpolld.h"
#include "time.h"
#include "log.h"

/*
 *   log -, : buf
 * buf:  .
 */
mylog(char *buf)
{
	FILE *logfile;
	char TIME[CHAR_MAX];
	char _logfile[PATH_MAX];
	char tty[CHAR_MAX];
	
	loginit( TIME ); _tty( tty );
	sprintf( _logfile, "%s.%s", LOGFILE, tty );
	if( ( logfile = fopen( _logfile, "a" ) ) == NULL ) exit ( -1 );
	fprintf( logfile, "%s ifpollD: %s\n", TIME, buf );
	fclose( logfile );
}

/*
 *   debug -, : buf -  ,
 * level -  
 */
#ifdef DEBUG
debug(char *buf, int level)
{
	FILE *debugfile;
	int _level;
	char TIME[CHAR_MAX];
	char _debugfile[PATH_MAX];
	char tty[CHAR_MAX];

	if( level > _debug(_level) ) return( 1 );
	loginit( TIME ); _tty( tty );
	sprintf( _debugfile, "%s.%s", DEBUGFILE, tty );
	if( ( debugfile = fopen( _debugfile, "a" ) ) == NULL ) exit ( -1 );
	fprintf( debugfile, "%s ifpollD[debug %d]: %s\n", TIME, level, buf );
	fclose( debugfile );
	return( 0 );
}
#endif
