/************************************************************************
 *	ifpollD -   FTN    poll'	*
 *	Copyright (c) Maxim Timofeyev, 1998				*
 *	NetMail: 2:5030/763@fidonet					*
 *	E-Mail:  tma@worldmailer.com					*
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <time.h>
#include <sys/wait.h>
#include <sys/resource.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <glob.h>
#include <dirent.h>
struct dirent Dirent;
#include <locale.h>
#include "default.h"
#include "ifpolld.h"
#include "string.h"
#include "version.h"
#include "Txy.h"
#include "log.h"
#include "time.h"
#include "rc.h"

static int MASTER = 0;	// 0 - slave, 1 - master

struct FTNADDR {
	int zone;
	int net;
	int node;
	int point;
	int flavor;	// 1 - crash
	char netlist[PATH_MAX];
	char pntlist[PATH_MAX];
} addr[MAXADDR];

struct CALLSTAT {
	time_t trytime;
	int tryno;
	int trystat;
} st;

static int _MAXDOMAIN=0;
static int _MAXNODE=0;
static int ADDR=0;
static char iTTY[CHAR_MAX];

struct POLLTIME
{
	int start;
	int end;
} polltime = { POLLSTART, POLLEND };	//     .

struct CONF
{
	int iDELAY;
#ifdef DEBUG
	int iDEBUG;
#endif
	int iTRY;
	int iMAILSIZE;
	char iPID[PATH_MAX];
	char iIFCICO[PATH_MAX];
	char iCONFIG[PATH_MAX];
	char iLOCK[PATH_MAX];
#ifdef DEBUG
} config = { DELAY, DEBUG, TRY, MAILSIZE, PID, IFCICO, CONFIG, LOCK };
#else
} config = { DELAY, TRY, MAILSIZE, PID, IFCICO, CONFIG, LOCK };
#endif

struct FTN {
	int poll;
	int zone;
	int net;
	int node;
	int point;
	int time;
} ftnaddr[MAXNODE];

struct DOMAIN {
	int zone;
	char domain[CHAR_MAX];
	char netlist[PATH_MAX];
	char pntlist[PATH_MAX];
} ftndomain[MAXDOMAIN];

void reinit(int sig_num);

main (int argc, char **argv)
{
	int fd, n;
	struct rlimit	flim;
	FILE *FPID;
	char pid[7];
	char buf[CHAR_MAX];
	char spool[PATH_MAX];

	//     
	if( getppid() != 1 ) {
		signal( SIGTTOU, SIG_IGN );
		signal( SIGTTIN, SIG_IGN );
		signal( SIGTSTP, SIG_IGN );
		signal( SIGHUP, reinit );
		if( fork() != 0 )
			exit( 0 );
		setsid();
	}
	getrlimit( RLIMIT_NOFILE, &flim );
	for( fd = 0; fd < flim.rlim_max; fd++ )
		close( fd );
	chdir( BINDIR );
	// ----------      -----------

	//   PID-.       PID -
	// ...

	//    
	if ( argc > 1 )
		strcpy( iTTY, argv[argc-1] );
	else
		strcpy( iTTY, TTY );

	sprintf( buf, "/dev/%s", iTTY );
	/*  -    	*
	 *       			*/
	if( ( access( buf, F_OK|R_OK|W_OK ) ) == -1 )
		strcpy( iTTY, "ttyS1" ); // ,   ttyS1  .

#ifdef DEBUG
	debug( "Reading config file!", 2 );
#endif

	readconf( CFGFILE );

#ifdef DEBUG
	debug( "Reading config file OK!", 2 );
#endif

	sprintf( config.iPID, "%s.%s", config.iPID, iTTY );
	checkpid();

#ifdef DEBUG
	sprintf(buf,"Creating PidFile: %s (pid = %d)",config.iPID,getpid());
	debug( buf, 2 );
#endif

	//  PID-   ...
	FPID = fopen( config.iPID, "w" );
	fprintf( FPID, "%d", getpid() );
	fclose( FPID );

#ifdef DEBUG
	debug( "Write version...", 2 );
#endif

	ver();		//    .

#ifdef NOTPOINTSYSTEM
	sprintf(buf,"ifpollD started (Node System). Use device \"/dev/%s\"",iTTY);
#else
	sprintf(buf,"ifpollD started (Point System). Use device \"/dev/%s\"",iTTY);
#endif
	mylog( buf );

	if( strncmp( iTTY, TTY, strlen(TTY) ) == 0 )
	{
		mylog( "Starting in Master mode!" );
		MASTER = 1;
	}
	else
		mylog( "Starting in Slave mode!" );

#ifdef DEBUG
	debug("Starting ok!", 2);
#endif

	//     -    poll'.
	pollnode_t();

	while( 1 )
	{
		ADDR=0; n=0;
		while( n != _MAXDOMAIN )
		{
			checkdomain( ftndomain[n].zone, spool );
			scanout( spool, 0, n ); n++;
		}

#ifdef DEBUG
		sprintf( buf, "Scaning %d addresses!", ADDR );
		debug( buf, 2 );
#endif

		//     crash poll!
		n=0;
		while( n != ADDR )
		{
#ifdef DEBUG
			sprintf(buf,"Check address for crash poll (number %d): %d:%d/%d.%d",n,
			  addr[n].zone,addr[n].net,addr[n].node,addr[n].point );
			debug( buf, 3 );
#endif

			if( addrbsy(n) == -1 )	//   ?
				if( addr[n].flavor == 1 )
				{
					debug("Found Crash poll address!", 1);
					ifcico(n);	// Crash poll
					_sleep( config.iDELAY );
				}
			n++;
		}

#ifdef DEBUG
		debug( "Check other...", 3 );
#endif

		// Crash Poll'  -    .
		n=0;
		while( n != ADDR )
		{
#ifdef DEBUG
			sprintf(buf,"Check address (number %d): %d:%d/%d.%d",n,
			  addr[n].zone,addr[n].net,addr[n].node,addr[n].point );
			debug( buf, 3 );
#endif
			//    .
			//  Crash Poll -      .
			if( addrbsy(n) == -1 )
			{
				if ( addr[n].flavor != 1 )
				{
					if( addr[n].point != 0 )
					{
						//  
						if( checkpnttxy(n) !=0 )
							ifcico(n);	// poll!
					}
					else
					{
						//  
						if( checknettxy(n) !=0 )
							ifcico(n);	// poll!
					}
					_sleep( config.iDELAY );
				}
			}
			n++;
		}
		if ( ADDR == 0 ) _sleep( config.iDELAY );
	}
}

void reinit(int sig_num)
{
	//     SIGHUP
	signal( sig_num, reinit );
	mylog( "Found SIGHUP signal - reconfig now!" );

	//    
	polltime.start=POLLSTART;
	polltime.end=POLLEND;
	_MAXDOMAIN=0;
	_MAXNODE=0;
	config.iDELAY=DELAY;
	config.iDEBUG=DEBUG;
	config.iTRY=TRY;
	config.iMAILSIZE=MAILSIZE;
	strcpy( config.iPID, PID );
	strcpy( config.iIFCICO, IFCICO );
	strcpy( config.iCONFIG, CONFIG );
	strcpy( config.iLOCK, LOCK );

	//  
	readconf( CFGFILE );
}

checkpid()
{
	FILE *FPID;
	int rpid;
	char pid[15];
	char buf[CHAR_MAX];
	if( (FPID = fopen( config.iPID, "r" ) ) != NULL )
	{
		fscanf( FPID, "%u", &rpid );
		fclose( FPID );
		if ( rpid == 0 )
		{
#ifdef DEBUG
			debug( "PidFile not found!", 2 );
#endif
			return ( 0 );
		}
#ifdef DEBUG
		sprintf( buf, "Check process, pid = %d", rpid );
		debug( buf, 2 );
#endif
#ifdef USE_PROC
		sprintf( pid, "/proc/%d", rpid );
		if( ( access( pid, F_OK ) ) == 0 )
		{
#endif
#ifdef DEBUG
			sprintf( buf, "Process found!, pid = %d, proc = \"%s\"", rpid, pid );
			debug( buf, 2 );
#endif
			sprintf( buf, "Error! PidFile already exists and ifpollD already running (pid = %d). I'm die!", rpid );
			mylog( buf );
			exit( 1 );
#ifdef USE_PROC
		}
		else
		{
			sprintf( buf, "PidFile already exist (pid = %d), but ifpollD is not loaded...", rpid );
			mylog( buf );
		}
#endif
	}
#ifdef DEBUG
	else
	{
		debug( "PidFile not found!", 2 );
	}
#endif
	return( 0 );
}

sys(char *buffer, char *addr, char *iconfig)
{
	pid_t pid;
	int status, save_errno;
	char tty[CHAR_MAX];

	sprintf( tty, "-l%s", iTTY );

	switch( pid = fork() )
	{
		case -1:	return(-1);
		case 0:		execl(buffer, buffer, tty, addr, iconfig, NULL);
				/* ugin@itc.mecom.ru */
				save_errno=errno; /* perror() may corruupt it */
				perror("execl");
				exit(save_errno);
	}
	if( waitpid(pid, &status, 0) == pid && WIFEXITED (status) )
		return WEXITSTATUS (status);
	return(-1);
}

//  ifcico
ifcico(int numaddr)
{
	int rc;
	char buf[CHAR_MAX];
	char address[CHAR_MAX];

	sprintf( address, "p%d.f%d.n%d.z%d", addr[numaddr].point,
		addr[numaddr].node,addr[numaddr].net,addr[numaddr].zone );

	if( checkpolltime() == 1 || addr[numaddr].flavor == 1 )
	{
#ifdef DEBUG
		debug( "Calling...", 2 );
#endif
		rc = 0;
		lock();	/*   LOCK - */
#ifdef DEBUG
		sprintf( buf, "Exec IFCICO: %s -l%s %s %s", config.iIFCICO,
			iTTY, address, config.iCONFIG );
		debug( buf, 3 );
#endif
		sprintf( buf, "Calling %d:%d/%d.%d (%s)",
			addr[numaddr].zone, addr[numaddr].net,
			addr[numaddr].node, addr[numaddr].point, iTTY);
		if ( addr[numaddr].flavor == 1 )
			sprintf ( buf, "%s - Crash poll!", buf );
		mylog( buf );
		rc = sys( config.iIFCICO, address, config.iCONFIG );

		sprintf( buf, "Return (rc = %d)", rc );

		switch( rc )
		{
			// All OK!
			case 0:
				sprintf( buf, "%s - %s", buf, RC0 );
#ifdef NOTPOINTSYSEM
				_sleep( config.iDELAY );
#endif
				break;
			// Could not connect to the remote
			case 2:
				sprintf( buf, "%s - %s", buf, RC2 );
				break;
			// Cannot call
			case 8:
				sprintf( buf, "%s - %s", buf, RC8 );
				break;
			// Line drop
			case 11:
				sprintf( buf, "%s - %s", buf, RC11 );
				// TODO   -  poll.
#ifdef NOTPOINSYSTEM
				_sleep( config.iDELAY );
#endif

				break;
			// error while waking remote
			case 30:
				sprintf( buf, "%s - %s", buf, RC30 );
				break;
			default:
#ifdef NOPOINTSYSTEM
				_sleep( config.iDELAY );
#endif
				break;
		}
		mylog ( buf );
	}
#ifdef DEBUG
	else
		debug( "Cannot poll!", 2 );
#endif
}

//    lock -.    -  1 sec
lock()
{
	while( 1 )
		if( ( access( config.iLOCK, F_OK ) ) == 0 )
			_sleep( 1 );
		else
			break;
}

readconf(char *conf)
{
	FILE *file;
	char buffer[CHAR_MAX];
	char *buf;
#ifdef DEBUG
	char _buf[CHAR_MAX];
#endif
	if ((file = fopen( conf, "r" )) == NULL)
	{
		mylog("Error! Config file don't exist! Use default...");
		return( 1 );
	}
	while( fgets( buffer, CHAR_MAX, file ) != NULL )
	{
	   if( strlen( buffer ) > 2 && buffer[0] != '#' )
	   {
		buf = strtok( buffer, "\n" );
		strcpy( buffer, buf );

#ifdef DEBUG
		sprintf( _buf, "Reading config... read \"%s\"", buffer );
		debug( _buf, 3 );
#endif
		if( strncmp(buffer, "PID=", 4) == 0 )
		{
			strconf (buffer);
			strcpy (config.iPID, buffer);
		}
		if( strncmp(buffer, "IFCICO=", 7) == 0 )
		{
			strconf (buffer);
			strcpy (config.iIFCICO, buffer);
		}
		if( strncmp(buffer, "CONFIG=", 7) == 0 )
		{
			strconf (buffer);
			strcpy (config.iCONFIG, buffer);
		}
		if( strncmp(buffer, "LOCK=", 5) == 0 )
		{
			strconf (buffer);
			sprintf( config.iLOCK, "%s%s", buffer, iTTY );
		}
		if( strncmp(buffer, "DELAY=", 6) == 0 )
		{
			strconf( buffer );
			config.iDELAY = atoi( buffer );
			if ( config.iDELAY < 0 )
				config.iDELAY = 1;
		}
		if( strncmp(buffer, "MAILSIZE=", 9) == 0 )
		{
			strconf( buffer );
			config.iMAILSIZE = atoi( buffer );
			if ( config.iMAILSIZE < 0 )
				config.iMAILSIZE = 0;
		}
#ifdef DEBUG
		if( strncmp(buffer, "DEBUG=", 6) == 0 )
		{
			strconf( buffer );
			config.iDEBUG = atoi( buffer );
			if ( config.iDEBUG < 0 || config.iDEBUG > 3 )
				config.iDEBUG = 3;
		}
#endif
		if( strncmp(buffer, "POLLTIME=", 9) == 0 )
			conftime ( buffer );
		if(strncmp(buffer,"DOMAIN=",7) == 0 && _MAXDOMAIN != MAXDOMAIN)
			readdomain ( buffer, _MAXDOMAIN++ );
		if( strncmp(buffer, "POLL=", 5) == 0 && _MAXNODE != MAXNODE )
			readpoll ( buffer, _MAXNODE++ );
		if( strncmp(buffer, "TRYPOLL=", 8) == 0 )
			readtry( buffer );
	   }
	}
	fclose( file );

#ifdef DEBUG
	sprintf( _buf, "Read total: domains %d(max %d), nodes: %d(max %d)",
			_MAXDOMAIN, MAXDOMAIN, _MAXNODE, MAXNODE );
	debug( _buf, 3 );
#endif

	return (0);
}

strconf(char *buffer)
{
	char *buf;
	buf = strstr( buffer, "=" ); *buf++;
	strcpy(buffer, buf);
}

readdomain(char *buffer, int i)
{
	char netlist[CHAR_MAX];
	char pntlist[CHAR_MAX];
#ifdef DEBUG
	char buf[CHAR_MAX];
#endif

	strconf (buffer);

	sscanf( buffer, "%u%*[ \t]%s%*[ \t]%s%*[ \t]%s",
		&ftndomain[i].zone, &ftndomain[i].domain,
		&ftndomain[i].netlist, &ftndomain[i].pntlist );

	//      (  )
	strlwr( ftndomain[i].domain );
	strlwr( ftndomain[i].netlist );
	strlwr( ftndomain[i].pntlist );

#ifdef DEBUG
	sprintf( buf,"Reading config... (#%d) Zone/Domain: %d/%s",
			i, ftndomain[i].zone, ftndomain[i].domain );
	debug( buf, 3 );
	sprintf( buf,"Reading config... NetList/PntList: %s/%s",
			ftndomain[i].netlist, ftndomain[i].pntlist );
#endif
}

readpoll(char *buffer, int i)
{
	int hour, min;
#ifdef DEBUG
	char buf[CHAR_MAX];
#endif

	strconf( buffer );

	sscanf( buffer, "%u:%u/%u.%u%*[ \t]%u:%u",
		&ftnaddr[i].zone, &ftnaddr[i].net,
		&ftnaddr[i].node, &ftnaddr[i].point, &hour, &min );

	//      .
	hour = checktime( hour, 23 );
	min = checktime( min, 59 );
	ftnaddr[i].poll = 0;	//   -  .

	ftnaddr[i].time = hour * 60 + min;

#ifdef DEBUG
	sprintf(buf,"Reading config... (#%d) Address: %d:%d/%d.%d (%02d:%02d)",
			i, ftnaddr[i].zone, ftnaddr[i].net,
			ftnaddr[i].node, ftnaddr[i].point, hour, min );
	debug( buf, 3 );
#endif
}

//    poll',   .
conftime(char *buffer)
{
	int n = 0, m = 0;
	int s_hour, s_min, e_hour, e_min;
	char buf[CHAR_MAX];
#ifdef DEBUG
	char _buf[CHAR_MAX];
#endif
	strconf( buffer );

	sscanf( buffer, "%u:%u-%u:%u",
		&s_hour, &s_min,
		&e_hour, &e_min );
	s_hour = checktime( s_hour, 23 );
	s_min = checktime( s_min, 59 );
	e_hour = checktime( e_hour, 23 );
	e_min = checktime( e_min, 59 );

#ifdef DEBUG
	sprintf( buf, "Reading config... PollTime: %02d:%02d-%02d:%02d",
		s_hour, s_min, e_hour, e_min);
	debug( buf, 2 );
#endif
	//   
	polltime.start = ( s_hour * 60 ) + s_min;
	polltime.end = ( e_hour * 60 ) + e_min;
	return( 0 );
}

checktime(int time, int max)
{
#ifdef DEBUG
	char buf[CHAR_MAX];
#endif
	if ( time < 0 || time > max )
	{
#ifdef DEBUG
		sprintf( buf, "Error time! Read %d, may be %d, set 0!",
				time, max );
		debug( buf, 3 );
#endif
		time = 0;
	}
	return ( time );
}

//     'TRYPOLL='
readtry(char *buffer)
{
#ifdef DEBUG
	char buf[CHAR_MAX];
#endif
	strconf (buffer);
	sscanf( buffer, "%u", &config.iTRY );
#ifdef DEBUG
	sprintf( buf, "Read config... TRY= %d",	config.iTRY );
	debug( buf, 3 );
#endif
}

//   ...
// 1 - , 0 - 
checkpolltime()
{
#ifdef DEBUG
	char buf[CHAR_MAX];
#endif
	time_t timv = time( 0 );
	struct tm *local_tm = localtime( &timv );
	int NowMin = local_tm->tm_hour * 60 + local_tm->tm_min;

#ifdef DEBUG
	debug( "Check PollTime...", 2 );
	sprintf( buf, "Poll time: %02u:%02u (%u min) - %02u:%02u (%u min), Now %02u:%02u (%u min)", polltime.start / 60, polltime.start % 60, polltime.start, polltime.end / 60, polltime.end % 60, polltime.end, local_tm->tm_hour, local_tm->tm_min, NowMin );
	debug( buf, 3 );
#endif

	if( polltime.start == polltime.end )
	{
#ifdef DEBUG
		debug( "polltime.start = polltime.end", 3 );
#endif
		return( 1 );
	}
	if( polltime.end > polltime.start )
	{
		if( NowMin >= polltime.start && NowMin < polltime.end )
		{
#ifdef DEBUG
			debug( "NowMin >= polltime.start && NowMin < polltime.end - calling", 3 );
#endif
			return( 1 );
		}
		else
		{
#ifdef DEBUG
			debug( "NowMin >= polltime.start && NowMin < polltime.end - cannot poll", 3 );
#endif
			return( 0 );
		}
	}
	else
	{
		if( NowMin >= polltime.start || NowMin < polltime.end )
		{
#ifdef DEBUG
			debug( "NowMin >= polltime.start || NowMin < polltime.end - calling", 3 );
#endif
			return( 1 );
		}
		else
		{
#ifdef DEBUG
			debug( "NowMin >= polltime.start || NowMin < polltime.end - cannot poll", 3 );
#endif
			return( 0 );
		}
	}
}

//   log.c     debug,
//   .
#ifdef DEBUG
_debug(int level)
{
	level = config.iDEBUG;
}
#endif

//   log.c    iTTY
_tty(char *tty)
{
	strcpy( tty, iTTY );
}

//   +    poll'.
_sleep(int sec)
{
#ifdef DEBUG
	char buf[CHAR_MAX];
#endif
	while( sec-- != 0 )
	{
		pollnode_t();
#ifdef DEBUG
	sprintf( buf, "Sleeping (_sleep())... %d sec", sec+1 );
	debug( buf, 3 );
#endif
		sleep( 1 );
	}
}

//    poll'.
pollnode_t()
{
	int n = 0;
	time_t timv = time( NULL );
	struct tm *local_tm = localtime ( &timv );
	int NowMin = local_tm->tm_hour * 60 + local_tm->tm_min;

	while( n != _MAXNODE )
		if( NowMin == ftnaddr[n].time &&
		    ftnaddr[n].poll != local_tm->tm_mday )
		{
			/*  ,   poll
			 *        ! */
			ftnaddr[n].poll = local_tm->tm_mday;
			pollnode( n++ );
		}
		else
			n++;
	return( 0 );
}

//  flo - (poll)
pollnode(int _node)
{
	int pollfile;
	char buf[CHAR_MAX];
	char buffer[CHAR_MAX];
	char domain[CHAR_MAX];
	char spool[PATH_MAX];
	char dir[PATH_MAX];
	if( ftnaddr[_node].zone == 0 )
	{
#ifdef DEBUG
		sprintf ( buf, "Bug! ftn-address is %d:%d/%d.%d",
		ftnaddr[_node].zone,
		ftnaddr[_node].net,
		ftnaddr[_node].node,
		ftnaddr[_node].point );
		debug ( buf, 1 );
#endif
		return( 1 );	/* TODO - !  */
		/*    ...     *
		 *    ... */
	}
	checkdomain( ftnaddr[_node].zone, spool );
	mkdir ( spool, 0700 );	//  ,   .
	if( ftnaddr[_node].point != 0 )
	{
		sprintf( dir, "%s/%04x%04x.pnt", spool,
			ftnaddr[_node].net,
			ftnaddr[_node].node );
		mkdir( dir, 0700 ); /*  ,   . */
		sprintf( spool, "%s/%08x", dir, ftnaddr[_node].point );
	}
	else
		sprintf( spool, "%s/%04x%04x", spool,
			ftnaddr[_node].net, ftnaddr[_node].node );

#ifdef DEBUG
	sprintf( buf, "Creating poll-file: \"%s.flo\"", spool );
	debug( buf, 1 );
#endif
	sprintf( buf, "Created poll for %d:%d/%d.%d",
		ftnaddr[_node].zone,
		ftnaddr[_node].net,
		ftnaddr[_node].node,
		ftnaddr[_node].point );
	mylog( buf );	/*     poll'. */

#ifdef POLLTRYNULL
	/*        */
	putstatusnull( spool );
#endif

	sprintf( buffer, "%s.flo", spool );
	if( (pollfile = open( buffer, O_WRONLY | O_CREAT | O_EXCL, 0600 )))
	{
#ifdef DEBUG
		sprintf( buf, "Poll-file \"%s\" already exists", buffer );
		debug( buf, 1 );
#endif
		return( 1 );
	}
	close( pollfile );
	return( 0 );
}

//  zone  domain   poll (  .flo)
checkdomain(int zone, char *spool)
{
	int rc=0, n=0;
#ifdef DEBUG
	char buf[CHAR_MAX];
#endif
	while( n != _MAXDOMAIN )
	{
#ifdef DEBUG
		sprintf( buf, "(#%d) Read zone = %d", n, zone );
		debug( buf, 3 );
		sprintf( buf, "If Zone %d = %d then domain is \"%s\"",
			zone, ftndomain[n].zone, ftndomain[n].domain );
		debug( buf, 3 );
#endif
		if( ftndomain[n].zone != zone )
			n++;
		else
			break;
	}
#ifdef DEBUG
	sprintf( buf, "Zone = %d, Domain = \"%s\"", zone, ftndomain[n].domain );
	debug( buf, 3 );
#endif
	if( n != _MAXDOMAIN )
	{
		sprintf( spool, "%s/%s", SPOOL, ftndomain[n].domain );
#ifdef DEBUG
		sprintf( buf, "Spool directory is \"%s\"", spool );
		debug( buf, 3 );
#endif
		return( 0 );
	}
	else
	{
		sprintf( spool, "%s/%s.%03x", SPOOL, DEFDOMAIN, zone );
#ifdef DEBUG
		sprintf( buf, "Domain not found! Spool directory is \"%s\", spool", spool );
		debug( buf, 3 );
#endif
		return( 1 );
	}
}

/*
 * dname -   spool'
 * ispoint = 0 - , 1 - 
 * numaddr -  -   spool'
 */
scanout(char *dname, int ispoint, int numzone)
{
	DIR *dp=NULL;
	struct dirent *de;
	int rc=0;
	int isflo;
	char buf[CHAR_MAX];
	char fname[PATH_MAX];
	char flavor='?';

	addr[ADDR].flavor = 0;	// default - normal

	if ((dp=opendir(dname)) == NULL)
	{
#ifdef DEBUG
		sprintf(buf,"outbound \"%s\" cannot be opened, proceed",dname);
		debug ( buf, 1 );
#endif
		return 0;
	}

	while ((de=readdir(dp)))
	if ((strlen(de->d_name) == 12) &&
	    (de->d_name[8] == '.') &&
	    (strspn(de->d_name,"0123456789abcdefABCDEF") == 8))
	{
#ifdef DEBUG
		sprintf(buf,"checking: \"%s\"",de->d_name);
		debug ( buf, 3 );
#endif
		addr[ADDR].point=0;
		strncpy(fname,dname,PATH_MAX-2);
		strcat(fname,"/");
		strncat(fname,de->d_name,PATH_MAX-strlen(fname)-2);
		if ((strcasecmp(de->d_name+9,"pnt") == 0) && !ispoint)
		{
			sscanf(de->d_name,"%04x%04x",&addr[ADDR].net,&addr[ADDR].node);
			if ((rc=scanout(fname,1,numzone))) goto exout;
		}
		else if ((strcasecmp(de->d_name+8,".out") == 0) ||
			 (strcasecmp(de->d_name+8,".cut") == 0) ||
//			 (strcasecmp(de->d_name+8,".cpk") == 0) ||
			 (strcasecmp(de->d_name+8,".flo") == 0) ||
			 (strcasecmp(de->d_name+8,".clo") == 0) ||
			 (strcasecmp(de->d_name+8,".hlo") == 0) ||
			 (strcasecmp(de->d_name+8,".flz") == 0) || // ZMH
			 (strcasecmp(de->d_name+8,".clz") == 0) || // ZMH
			 (strcasecmp(de->d_name+8,".hlz") == 0) || // ZMH
			 (strcasecmp(de->d_name+8,".req") == 0))
		{
			flavor = tolower(de->d_name[9]);

			if (ispoint)
				sscanf(de->d_name,"%08x",
					&addr[ADDR].point);
			else
				sscanf(de->d_name,"%04x%04x",
					&addr[ADDR].net,&addr[ADDR].node);

			if( flavor == 'c' && tolower(de->d_name[11]) != 'z' )
				addr[ADDR].flavor=1;

			addr[ADDR].zone = ftndomain[numzone].zone;
			strcpy(addr[ADDR].netlist, ftndomain[numzone].netlist);
			strcpy(addr[ADDR].pntlist, ftndomain[numzone].pntlist);

			//  ZMH  __ NetMail
			//  ZMH -  *.f[c]lo  *.f[c]lz
			//   ZMH -  *.f[c]lz  *.f[c]lo
			//   __ 'ifpollD master'
#ifdef ZMHFLO
			if ( MASTER == 1 )
				zmh( dname, de->d_name );
#endif

			if ( flavor != 'h' )
			  //    .
			  if( ADDR > 0 && dubladdr(de->d_name) == 1 )
			  {
#ifdef DEBUG
			  sprintf( buf, "address already exist: %d:%d/%d.%d",
				addr[ADDR].zone, addr[ADDR].net,
				addr[ADDR].node, addr[ADDR].point );
			  debug( buf, 1 );
#endif
			  } else if( getstatus(ADDR) != -1 ) {
#ifdef DEBUG
			  sprintf( buf, "address: %d:%d/%d.%d",
				addr[ADDR].zone, addr[ADDR].net,
				addr[ADDR].node, addr[ADDR].point );
			  debug( buf, 1 );
			  sprintf( buf, "Number: %d", ADDR+1 );
			  debug( buf, 1 );
			  if( addr[ADDR].flavor == 1 )
				debug( "Crash poll!", 1 );
#endif

			  if( sizeout( fname, de->d_name ) != 0 )
				if( tolower(de->d_name[11]) != 'z' &&
				    flavor != 'h' )
					ADDR++;
			}
		}
		else
		{
#ifdef DEBUG
			sprintf(buf,"skipping \"%s\"",de->d_name);
			debug( buf, 3 );
#endif
		}
	}

exout:
	closedir(dp);
	return(rc);
}

//     .
// 1 -    ! 0 -    .
dubladdr(char *dname)
{
	int i=-1;
	char buf[CHAR_MAX];

	while( ++i < ADDR )
		if( addr[ADDR].zone == addr[i].zone &&
		    addr[ADDR].net == addr[i].net &&
		    addr[ADDR].node == addr[i].node &&
		    addr[ADDR].point == addr[i].point )
			if( tolower(dname[9]) != 'c' )
				return( 1 );
			else
			{
				addr[i].flavor = 1;	//  crash poll!
				sprintf( buf, "Change status \"Normal poll\" -> \"Crash poll\"! (%d:%d/%d.%d)",
					addr[i].zone, addr[i].net,
					addr[i].node, addr[i].point );
				mylog( buf );
				return( 1 );
			}
	return( 0 );
}

//    NetMail'.
sizeout(fname, dname)
char fname[PATH_MAX];
char dname[13];
{
	struct stat statv;
#ifdef DEBUG
	char buf[CHAR_MAX];
#endif

	if( tolower(dname[9]) != 'o' ) return( 1 ); //   Normal NetMail
	if( config.iMAILSIZE == 0 ) return( 1 ); //   !

	stat( fname, &statv );
#ifdef DEBUG
	sprintf( buf, "Check file \"%s\"", fname );
	debug( buf, 3 );
	sprintf( buf, "File size: %d bytes", statv.st_size );
	debug( buf, 3 );
#endif

	if( statv.st_size > config.iMAILSIZE )
	{
#ifdef DEBUG
	sprintf(buf,"MailSize: %d > %db, address: %d:%d/%d.%d may be polling.",
		statv.st_size, config.iMAILSIZE,
		addr[ADDR].zone, addr[ADDR].net,
		addr[ADDR].node, addr[ADDR].point );
	debug( buf, 1 );
#endif
		return( 1 ); //  NetMail'  -  
	}
#ifdef DEBUG
	sprintf(buf,"Cannot call! MailSize: %d < %db (address: %d:%d/%d.%d)",
		statv.st_size, config.iMAILSIZE,
		addr[ADDR].zone, addr[ADDR].net,
		addr[ADDR].node, addr[ADDR].point );
	debug( buf, 1 );
#endif
	return( 0 );	//  .
}

// 0 -  , 1 - 
checknettxy(int numaddr)
{
	FILE *in;
	int i=0, rc=0;
	char buf[CHAR_MAX];
	char list[PATH_MAX];
	char buffer[CHAR_MAX];
	char xy[2];

	//    0 -  .
	if( addr[numaddr].node == 0 )
		sprintf( buffer, "Host,%d,", addr[numaddr].net );
	else
		sprintf( buffer, ",%d,", addr[numaddr].node );

#ifdef DEBUG
	sprintf( buf, "Check Txy flag (%d:%d/%d.%d)", addr[numaddr].zone,
		addr[numaddr].net, addr[numaddr].node, addr[numaddr].point );
	debug( buf, 3 );
	sprintf( buf, "Look for \"%s\" line", buffer );
	debug( buf, 3 );
#endif

	nodelist( addr[numaddr].netlist, list );

	in = fopen( list, "r" );

	while( fgets( buf, CHAR_MAX, in ) != NULL )
		if( strstr( buf, buffer )!=NULL )
		{
			while( buf[i++] != 0 )
				if( buf[i-1] == 'U' && buf[i] == ',' &&
					buf[i+1] == 'T' )
				{
#ifdef DEBUG
					debug ( buf, 3 );
					sprintf ( buffer, "Flag Txy = %c%c",
						buf[i+2], buf[i+3] );
					debug ( buffer, 3 );
#endif
					xy[0] = buf[i+2];
					xy[1] = buf[i+3];
					if( txy( xy ) != 0 ) rc=1;
					goto ex;
				} else
				if( buf[i-1] == ',' && buf[i] == 'C' &&
					buf[i+1] == 'M' )
				{
#ifdef DEBUG
					debug ( buf, 3 );
					debug ( "CM node!", 3 );
#endif
					rc=1;
				}
		}

	if ( rc != 1 )
	{
		if( strncmp( buf, "Down,", 5 ) !=0 ||
			strncmp( buf, "Hold,", 5 ) !=0 )
		{
#ifdef DEBUG
			debug ( buf, 3 );
			debug ( "Only ZMH!", 3 );
#endif
			strcpy( xy, ZMH );
			rc=1;
			goto ex;
		}
		else
		{
#ifdef DEBUG
			debug ( "Hold or Down node!", 2 );
#endif
			goto ex;
		}
#ifdef DEBUG
		sprintf(buf,"Node or flag not found! (%d:%d/%d.%d), List \"%s\"",
			addr[numaddr].zone,addr[numaddr].net,
			addr[numaddr].node,addr[numaddr].point,
			addr[numaddr].netlist);
		debug( buf, 3 );
#endif
	}
ex:
	fclose( in );
	return( rc );
}

// 0 -  , 1 - 
checkpnttxy(int numaddr)
{
	FILE *in;
	int i=0, rc=0;
	char buf[CHAR_MAX];
	char list[PATH_MAX];
	char buffer[CHAR_MAX];
	char boss[CHAR_MAX];
	char _point[CHAR_MAX];
	char xy[2];

	sprintf ( boss, "Boss,%d:%d/%d",
		addr[numaddr].zone, addr[numaddr].net, addr[numaddr].node );
	sprintf ( _point, "Point,%d,", addr[numaddr].point );

#ifdef DEBUG
	sprintf( buf, "Check Txy flag (%d:%d/%d.%d)", addr[numaddr].zone,
		addr[numaddr].net, addr[numaddr].node, addr[numaddr].point );
	debug( buf, 3 );
	sprintf( buf, "Look for \"%s\" line", boss );
	debug( buf, 3 );
#endif

	nodelist( addr[numaddr].pntlist, list );

	in = fopen( list, "r" );

	while( fgets( buf, CHAR_MAX-1, in )!=NULL)
		if( strncmp( buf, boss, strlen(boss) )==0 )
		{
#ifdef DEBUG
			sprintf( buf, "Look for \"%s\" line", _point );
			debug( buf, 3 );
#endif
			while( fgets( buf, CHAR_MAX-1, in )!=NULL)
				if( strncmp( buf, _point, strlen(_point))==0 )
				{
				  while( buf[i++] != 0 )
				    if( buf[i-1] == 'U' && buf[i] == ',' &&
					buf[i+1] == 'T' )
				    {
#ifdef DEBUG
					debug ( buf, 3 );
					sprintf ( buffer, "Flag Txy = %c%c",
						buf[i+2], buf[i+3] );
					debug ( buffer, 3 );
#endif
					xy[0] = buf[i+2];
					xy[1] = buf[i+3];
					if( txy( xy ) != 0 ) rc=1;
					goto ex;
				    }
				    else if( buf[i-1] == ',' && buf[i] == 'C' &&
					buf[i+1] == 'M' )
				    {
#ifdef DEBUG
					debug ( buf, 3 );
					debug ( "CM point!", 3 );
#endif
					rc=1;
				    }
				}
		}
#ifdef DEBUG
	if ( rc != 1 )
	{
		sprintf(buf,"Point or flag not found! (%d:%d/%d.%d), List \"%s\"",
			addr[numaddr].zone,addr[numaddr].net,
			addr[numaddr].node,addr[numaddr].point,
			addr[numaddr].pntlist);
		debug( buf, 3 );
	}
#endif
ex:
	fclose( in );
	return( rc );
}

nodelist(nlist, list)
char nlist[CHAR_MAX];
char list[PATH_MAX];
{
	int k;
	char fullname[PATH_MAX];

	glob_t globbuf;
	globbuf.gl_pathc=0;
	globbuf.gl_pathv=NULL;

	sprintf( fullname, "%s/%s.*", NODELIST, nlist );

	glob( fullname, GLOB_NOSORT|GLOB_APPEND|GLOB_MARK|GLOB_NOCHECK,NULL,
			&globbuf );
	for( k = 0; k < globbuf.gl_pathc; k++ )
		strcpy( list, globbuf.gl_pathv[k] );
	globfree( &globbuf );
}

//       .
getstatus(int numaddr)
{
	FILE *fp;
	time_t now;

	char stsfile[PATH_MAX];
#ifdef DEBUG
	char buf[CHAR_MAX];
#endif

	st.trytime=0L;
	st.tryno=0;
	st.trystat=0;

	addrspool( numaddr, stsfile );
	sprintf( stsfile, "%s.sts", stsfile );

	if ( (fp=fopen( stsfile, "r")) )
	{
		fscanf(fp, "%lu %u %u", &st.trytime, &st.tryno, &st.trystat);
		fclose(fp);
	}

	(void)time(&now);

	if ( st.tryno > config.iTRY-1 )
	{
#ifdef DEBUG
		sprintf( buf, "Warning! Node %d:%d/%d.%d, try number %d (max try = %d)",
			addr[numaddr].zone, addr[numaddr].net,
			addr[numaddr].node, addr[numaddr].point,
			st.tryno, config.iTRY );
		debug( buf, 1 );
#endif
		st.tryno = -1;
	}

	return ( st.tryno );
}

#ifdef POLLTRYNULL
putstatusnull(char *spool)
{
	FILE *fp;

	char buf[CHAR_MAX];
	char stsfile[PATH_MAX];

	sprintf( stsfile, "%s.sts", spool );

	if ( (fp=fopen( stsfile, "r")) )
	{
		fscanf(fp, "%lu %u %u", &st.trytime, &st.tryno, &st.trystat);
		fclose(fp);

		if( (fp=fopen(stsfile,"w")) )
		{
			if( config.iTRY > 0 && st.tryno >= config.iTRY )
				st.tryno = 0;
			fprintf(fp,"%lu %u %u",st.trytime,st.tryno,st.trystat);
			fclose(fp);
		}
		else
		{
			sprintf( buf, "cannot create status file \"%s\"",
				stsfile );
			debug( buf, 1 );
		}
	}
}
#endif

addrspool(numaddr, file)
int numaddr;
char file[PATH_MAX];
{
	char spool[PATH_MAX];

	checkdomain( addr[numaddr].zone, spool );

	if( ftnaddr[numaddr].point != 0 )
	{
		sprintf( spool, "%s/%04x%04x.pnt", spool,
			addr[numaddr].net,
			addr[numaddr].node );
		sprintf( file, "%s/%08x", spool, addr[numaddr].point );
	}
	else
		sprintf( file, "%s/%04x%04x", spool,
			addr[numaddr].net, addr[numaddr].node );
}

addrbsy(int numaddr)
{
	int rc;
	char buf[CHAR_MAX];

	addrspool( numaddr, buf );
	sprintf( buf, "%s.bsy", buf );
	rc = access( buf, F_OK ); // -1 -    .
	if( rc == 0 )
	{
		sprintf(buf,"bsy file found (%d:%d/%d.%d)",
		  addr[numaddr].zone, addr[numaddr].net,
		  addr[numaddr].node, addr[numaddr].point );
		mylog( buf );
	}
	return( rc );
}
