# include <ctype.h>
# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include <unistd.h>
# ifdef HAS_SYSLOG
#  include <syslog.h>
# endif
# include <sys/types.h>

# include "lgetopt.h"
# include "lutil.h"
# include "nodelist.h"
# include "nlindex.h"
# include "config.h"
# include "version.h"
# include "trap.h"

static int Verbose = 0;

void usage(void)
{
	confusage(" -v ADDR\n"
			  "\n"
			  "    Copyright (c) 1995 by Boris Tobotras, 2:5020/510\n"
			  "\n"
			  "-v  returns full information from nodelist entry\n"
			  "\n"
			  "ADDR can be incompete. Syntax is following:\n"
			  "\n"
			  "    [[[ZZZ:]NNNN/]FFF][.PPP]\n" );
}

void Lookup( char *Address )
{
	faddr addr;
	char *p;
	node *nlent;

	static char space = '\0';

	if ( space )
		putchar( Verbose ? '\n' : ' ' );
	else
		space = ' ';

	addr.name = NULL;
	addr.domain = whoami->addr->domain;

	p = Address;

	{ 
		char *eol = Address + strlen( Address ) - 1;
		while ( eol > Address + 1 && isspace( eol[ -1 ] ) )
			--eol;
		eol[ 1 ] = '\0';
	}

	if ( isdigit( *p ) ) {
		int n = strtol( p, &p, 10 );
		switch ( *p ) {
		  case '\0':
			addr.zone = whoami->addr->zone;
			addr.net  = whoami->addr->net;
			addr.node = n;
			addr.point= 0;
			break;
		  case ':':
			addr.zone = n;
			++p;			
			addr.net = strtol( p, &p, 10 );
			if ( *p++ != '/' ) {
			  Syntax:
				printf( Address );
				return;
			}
		  ParseNodeAndPoint:
			addr.node = strtol( p, &p, 10 );
			addr.point = 0;
			if ( *p ) {
				if ( *p++ != '.' )
					goto Syntax;
				addr.point = atoi( p );
			}
			break;
				
		  case '.':
			addr.zone = whoami->addr->zone;
			addr.net  = whoami->addr->net;
			addr.node = n;
			addr.point = atoi( ++p );
			break;
		  case '/':
			addr.zone = whoami->addr->zone;
			addr.net = n;
			++p;
			goto ParseNodeAndPoint;
		}
	}
	else {
		if ( *p++ != '.' )
			goto Syntax;
		addr.zone = whoami->addr->zone;
		addr.net  = whoami->addr->net;
		addr.node = whoami->addr->node;
		addr.point= atoi( p );
	}

	nlent = getnlent( &addr ); 

	if ( !nlent )
		puts( Address );
	else {
		char *period, *name;
		dom_trans *trans;
		
		if ( Verbose )
			printf( "Internet address: " );

		name = strdup( nlent->sysop );
		while ( ( period = strchr( name, ' ' ) ) )
			*period	= dots[0];
		printf( "%s@", name );
		free( name );
		if ( nlent->addr.point )
			printf( "p%u.", nlent->addr.point );
		printf( "f%u.n%u.z%u", nlent->addr.node, nlent->addr.net, 
			   nlent->addr.zone );
		if ( !nlent->addr.domain )
			nlent->addr.domain = whoami->addr->domain;
		for ( trans = domtrans; trans; trans = trans->next ) {
			if ( trans->ftndom[ 0 ] == '.' 
				&& !strcasecmp( trans->ftndom + 1, nlent->addr.domain ) )
				break;
		}
		printf( trans ? trans->intdom : "<no domain - error!>" );
		if ( Verbose ) {
			unsigned long mask;
			int firstFlag = 1;
			
			printf( "\nFidoNet address: %u:%u/%u", nlent->addr.zone, nlent->addr.net,
				   nlent->addr.node );
			if ( nlent->addr.point > 0 )
				printf( ".%u", nlent->addr.point );
			printf( "@%s", nlent->addr.domain );
			
			if ( nlent->pflag & NL_DOWN )
				printf( ", DOWN" );
			if ( nlent->pflag & NL_HOLD )
				printf( ", HOLD" );
			if ( nlent->pflag & NL_PVT )
				printf( ", PVT" );
			printf( "\nName: %s\n", nlent->name );
			printf( "Location: %s\n", nlent->location );
			printf( "SysOp: %s\n", nlent->sysop );
			printf( "Phone: %s\n", nlent->phone );
			printf( "Speed: %u\nFlags: ", nlent->speed );
			for ( mask = 1L; mask; mask <<= 1 )
				if ( nlent->flags & ~NL_RQMODE & mask ) {
					switch ( mask )	{
					  case NL_CM:
						p = "CM"; break;
					  case NL_MO:
						p = "MO"; break;
					  case NL_LO:
						p = "LO"; break;
					  case NL_V21:
						p = "V21"; break;
					  case NL_V22:
						p = "V22"; break;
					  case NL_V29:
						p = "V29"; break;
					  case NL_V32:
						p = "V32"; break;
					  case NL_V32B:
						p = "V32B"; break;
					  case NL_V33:
						p = "V33"; break;
					  case NL_V34:
						p = "V34"; break;
					  case NL_V42:
						p = "V42"; break;
					  case NL_V42B:
						p = "V42B"; break;
					  case NL_MNP:
						p = "MNP"; break;
					  case NL_H96:
						p = "H96"; break;
					  case NL_HST:
						p = "HST"; break;
					  case NL_H14:
						p = "H14"; break;
					  case NL_H16:
						p = "H16"; break;
					  case NL_MAX:
						p = "MAX"; break;
					  case NL_PEP:
						p = "PEP"; break;
					  case NL_CSP:
						p = "CSP"; break;
					  case NL_ZYX:
						p = "ZYX"; break;
					  case NL_MN:
						p = "MN"; break;
					  default: {
						  static char bug[ 30 ];
						  sprintf( bug, "%08lx", mask );
						  p = bug; break;
						}
					}
					if ( firstFlag )
						firstFlag = 0;
					else
						printf( ", " );
					printf( p );
				}
			if ( nlent->flags & NL_RQMODE ) {
				switch ( nlent->flags & NL_RQMODE ) {
				  case NL_XA:
					p = "XA"; break;
				  case NL_XB:
					p = "XB"; break;
				  case NL_XC:
					p = "XC"; break;
				  case NL_XP:
					p = "XP"; break;
				  case NL_XR:
					p = "XR"; break;
				  case NL_XW:
					p = "XW"; break;
				  case NL_XX:
					p = "XX"; break;
				  default: {
					static char bug[ 30 ];
					sprintf( bug, "%08lx", nlent->flags & NL_RQMODE );
					p = bug; break;
					}
				}
				if ( firstFlag )
					firstFlag = 0;
				else
					printf( ", " );
				printf( p );
			}
			{
				int i;
				for ( i = 0; i < MAXUFLAGS && nlent->uflags[ i ]; ++i ) {
					if ( firstFlag )
						firstFlag = 0;
					else
						printf( ", " );
					printf( nlent->uflags[ i ] );
				}
			}
			putchar( '\n' );
		}
	}
}

int main( int argc, char *argv[] )
{
	int c, rc;

#if defined( HAS_SYSLOG ) && defined( MAILLOG )
	logfacility = MAILLOG;
#endif

	setmyname( argv[ 0 ] );
	catch( myname );
	while ( ( c = getopt( argc, argv, "x:I:hv" ) ) != -1 )
		if ( confopt( c, optarg ) )
			switch ( c ) {
			  case 'v':
				Verbose = 1;
				break;
			  default:
				usage(); 
				exit(1);
			}

	if ( optind == argc ) {
		usage();
		exit( 1 );
	}
	
	if ( ( rc = readconfig() ) )
		{
			fprintf( stderr, "Error getting configuration, aborting\n" );
			return rc;
		}

	while ( optind < argc )
		Lookup( argv[ optind++ ] );

	putchar( '\n' );

	return 0;
}
