#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <time.h>
#include "lutil.h"
#include "config.h"


/**
 * Generate a (hopefully) uniq sequence number.
 */
unsigned long sequencer(void)
{
  static unsigned long last_id = 0;
  unsigned long id = 0;


  id = (unsigned long) time(NULL);

  if (sequence != NULL)
  {
    FILE *fp;

    if ((fp = fopen(sequence, "r+")) == NULL)
    {
      fp = fopen(sequence, "w");
    }

    if (fp != NULL)
    {
      struct flock fl;

      fl.l_type = F_WRLCK;
      fl.l_whence = 0;
      fl.l_start = 0L;
      fl.l_len = 0L;
      fcntl(fileno(fp), F_SETLKW, &fl);
      fscanf(fp, "%lu", &id);
      rewind(fp);
      fprintf(fp, "%lu\n", ++id);
      fclose(fp);
    }
    else
    {
      /* Only output a warning if we are called for the first time. */
      if (last_id == 0)
      {
	loginf("Can't open sequencer file, please check your setup");
      }
    }
  }
  else
  {
    if (last_id == 0)
    {
      /* Only output a warning if we are called for the first time. */
      loginf("sequencer not set up correctly, please check your config");
    }
  }

  /* Don't return the same id twice */
  if (id <= last_id)
  {
    last_id++;
    id = last_id;
  }
  else
  {
    last_id = id;
  }


  return id;
}
