/*
  time to string routines
*/

#include <stdlib.h>
#include <stdio.h>
#include <time.h>

#include "texttime.h"

char *texttime(int islocal)
{
	static time_t t;
	static struct tm *tt;
	static char str[99];
	
	time(&t);
	if (islocal) tt = localtime(&t);
	else tt = gmtime(&t);
	
	strftime(str, 99, "%a %b %d %H:%M:%S %Y", tt);
	return str;
}

/*
 * textUTC not used by gtic
 *
 * Valery: what is tm->tm_gmtoff ???
 *
char *textUTC(void)
{
	static char str[99];
	int h, m, t;
	time_t th_time;
	struct tm *lc_time;
	
	tzset();

	th_time = clock();
	lc_time = localtime(&th_time);

	t = abs(lc_time->tm_gmtoff);
	
	h = ((t / 3600) % 100);
	m = (t / 60) % 60;
	
	snprintf(str,sizeof(str)-1,"UTC%c%.2d%.2d",
		(lc_time->tm_gmtoff<=0)?'-':'+',h,m);
	return str;
}
*/
