#ifndef _STRUCTS_H
#define _STRUCTS_H

#include <time.h>

/*
 desc_dir    ԣ (strchr(desc_dir,'/')!=NULL),  
.desc   dir
*/

typedef struct tic /* TODO: full FSC-0087 support */
{
  char *area;		/* required */
  char *areadesc;
  char *file;		/* required */
  char *realname;	/* real file name in file system, by find_file */
  char *fullname;	/* TODO */
  unsigned long crc;	/* required, 0 if unknown (TODO: check for zero!) */
  char *magic;
  char *replaces;
  ilist_t *desc;	
  int max_desc;		/* desc count, must be initializated to 0 */
  ilist_t *ldesc;
  int max_ldesc;	/* ldesc count, must be initializated to 0 */
  unsigned long size;	/* -1 if size unknown */
  time_t date;		/* -1 if date unknown */
  time_t release;	/* -1 if release unknown */
  char *author;
  char *source;		/* always passthru */
  ilist_t *app;
  int max_app;		/* app count, must be initializated to 0 */
  node_t origin;	/* required, .zone=0 if unknown */
  node_t from;		/* required, .zone=0 if unknown */
  char *from_pwd;	/* TODO */
  node_t to;		/* .zone=0 if unknown */
  char *created;	/* required */
  ilist_t *via;		/* see comment below */
  int max_via;		/* via count, must be initializated to 0 */
  ilist_t *path;	/* required */
  int max_path;		/* path count, must be initializated to 0 */
  list_t *seenby;	/* required, key - node, entry - "" */
  char *pw;		/* required */

/*
ReceiptRequest can be ignored by FSC-0087
PGP is "To be discussed" by FSC-0087 - ignored by gtic now
Via field is passed (can be unchanged by FSC-0087)
*/

} tic_t;

#define TICLIST_INBOUND 0
#define TICLIST_BADDIR  1
#define TICLIST_OTHER	2
#define OLDTIC_OK	0
#define OLDTIC_KEEP	1
#define OLDTIC_REMOVE	2
typedef struct ticlist
{
  int type; 		/* TICLIST_ */
  int bad;		/* FALSE - ok, TRUE - bad */
  char *path;		/* path dir dir with (points to inbound or bad_dir) */
  char *name;		/* tic's name */
  char *badname;	/* tic's badname (name renames to badname) */
  int old_tic;		/* 0 - ok, 1 - keep old tic, 2 - remove old tic */
  time_t ctime;		/* change time of tic, use with wait_file */
  tic_t *tic;		/* tic_t full tic structure, read by readtics() */
} ticlist_t;

#define USER_HOLD		0x00000001
#define USER_AUTOCREATE		0x00000002
#define USER_PAUSE		0x00000004
#define USER_AUTO_RW		0x00000008
#define USER_AUTO_RO		0x00000010
#define USER_NO_TICS		0x00000020
typedef struct user
{
  node_t addr;
  char *passwd;
  list_t *groups;	/* user groups, key=group, entry=NULL */
  int flags;
} user_t;

#define AREA_READONLY		0x00000001
#define AREA_PASSTHRU		0x00000002
#define AREA_NOANNOUNCE		0x00000004
#define AREA_PRIVATE_ANNOUNCE	0x00000008
#define AREA_NO_DESC		0x00000010
#define AREA_NO_REPLACES	0x00000020
typedef struct area
{
  char *name;		/* required */
  char *desc;		/* use default when NULL */
  char *path;		/* required */
  node_t *aka;		/* use default when NULL */
  list_t *users; /* key=ftn_addr (with ! in first pos if readonly link)
                  entry=list_find[_entry?](users, key_with_out_!_in_first_pos )
									*/
		          /* required */
  char *group;		/* area group, no group when NULL */
  int flags;   		/* real_flags | areagroup_config's flags */
  int real_flags; 	/* don't write in writeareas when 0 */
  int mode;		/* use default when -1 */ 
  char *newfile;	/* use default when NULL */

  int group_options;	/* TRUE when additionals options read from areagroups */
} area_t;

struct flag_tab { int bitmask; char *text; } ;

#endif
