#ifndef	_MYASSERT_H
#define	_MYASSERT_H


/* Version 2.4 and later of GCC define a magical variable `__PRETTY_FUNCTION__'
   which contains the name of the function currently being defined.
   This is broken in G++ before version 2.6.  */
#if (!defined __GNUC__ || __GNUC__ < 2 || \
     __GNUC_MINOR__ < (defined __cplusplus ? 6 : 4))
#define __ASSERT_FUNCTION	((__const char *) 0)
#else
#define __ASSERT_FUNCTION	__PRETTY_FUNCTION__
#endif

void my__assert_fail(char *,char *,unsigned int,char *);

/*
Yuri Kuzmenko:
__assert_fail changed for gtic file forwarder
assert() renamed to ass() be me ;-)
*/

#define ass(expr)							      \
  ((void) ((expr) ? 0 :							      \
	   (my__assert_fail (__STRING(expr),				      \
			   __FILE__, __LINE__, __ASSERT_FUNCTION), 0)))

#endif
