#ifndef _LISTS_H
#define _LISTS_H
/* List implementation */

typedef struct list_s
{
  struct list_s *next, *prev;
  int max;
  void *entry;
  char *key;
} list_t;

typedef struct ilist_s
{
  struct ilist_s *next, *prev;
	int max;
  void *entry;
  int key;
} ilist_t;

#define ilist_entry(l) (l)->entry
#define ilist_key(l)   (l)->key
#define ilist_next(l)  (l)->next
#define ilist_prev(l)  (l)->prev

#define list_entry(l) (l)->entry
#define list_key(l)   (l)->key
#define list_next(l)  (l)->next
#define list_prev(l)  (l)->prev
#define list_head_max(l)   (l)->max		/* only for head of list */
#define ilist_head_max(l)  (l)->max		/* only for head of list */

list_t *list_init(void);
ilist_t *ilist_init(void);
int list_add(list_t * list, char *key, void *entry);
int ilist_add(ilist_t * ilist, int key, void *entry);
int list_remove(list_t * list, char *key);
int ilist_remove(ilist_t * ilist, int key);
void list_free(list_t * list);
void ilist_free(ilist_t * list);
void list_unlink(list_t * ent);
void ilist_unlink(ilist_t * ent);
list_t *list_find(list_t * list, char *key);
list_t *list_get(list_t * list,int n);
ilist_t *ilist_get(ilist_t * list,int n);
ilist_t *ilist_find(ilist_t * list, int key);

void *ilist_find_entry(ilist_t *ilist,int key);
void *list_find_entry(list_t *list,char *key);
void *list_find_key(list_t *list,char *key);
void *list_get_entry(list_t *list,int n);
void *ilist_get_entry(ilist_t *list,int n);
void *list_get_key(list_t *list,int n);

#endif /* _LISTS_H */
