#ifndef _FUNCS_H
#define _FUNCS_H

#include <stdio.h>

#include "lists.h"
#include "fido.h"
#include "structs.h"
#include "logger.h"
#include "texttime.h"
#include "lock.h"
#include "xmalloc.h"
#include "xutil.h"
#include "lock.h"
#include "strutil.h"
#include "domains.h"

extern void hatcher(void);

extern void area_manager(void);

extern void mkdirs(char *,int);

extern void write_flag_tab_to_FILE(FILE *fp,int flags,struct flag_tab *tab);

extern int dirmode(int filemode);

extern int wildmat(char *text, char *p);
extern int wildmat_icase(char *text, char *p);

extern void toss(void);

extern int validate_group(area_t *a,user_t *u);

extern void freetic(tic_t *);
extern tic_t *copytic(tic_t *);
extern void readticlist(void);
extern void read_tics_from_list(void);
extern void freeticlist(void);
extern int writeticFILE(tic_t *,FILE *); /* returns 0 when success */

extern void readconfig(char *);
extern void readusers(void);
extern void readareas(void);
extern void writeusers(void);
extern void writeareas(void);

extern void a2k(unsigned char *,long);
extern void k2a(unsigned char *,long);

extern unsigned long filecrc32(const char *name);

extern int access_via_stat(char *name,int mode);
extern int ln(char *oldname,char *newname);
extern int cp(char *oldname,char *newname);
extern int cp_add(char *oldname,char *newname);
extern int mv(char *oldname,char *newname);
extern int find_file(char *dirname, char *outbuff,char *origname,
		unsigned long crc32,unsigned long size);
extern void rm_by_mask(char *dirname, char *mask);

#endif
