/*
	domain_file support
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

#include "config.h"

/* key - zone, value - path to outbound */
ilist_t *domains=NULL;

void read_domains_file()
{
	char buff[PATH_MAX+10];
	FILE *fp;
	int linecnt=0;
	char *czone,*cpath;
	ass(domains==NULL);
	domains=ilist_init();
	fp=fopen(domains_file,"rb");
	if(fp==NULL)
	{
		e_printf("unable to open domains_file %s: ",domains_file);
		perror("");
		abort2();
	}
	while(1)
	{
		if(!fgets(buff,sizeof(buff)-1,fp)) break;
		linecnt++;
		delcrlf(buff);
		if(buff[0]=='#' || buff[0]==0) continue;
		czone=strtok(buff," \t");
		if(czone)
			cpath=strtok(NULL," \t");
		if(czone==NULL || cpath==NULL)
		{
			e_printf("%s(%d): invalid string, must be \"%%d %%s\", zone, path",
				domains_file,linecnt);
		}
		ilist_add(domains,atoi(czone),xstrcpy(cpath));
	}
	fclose(fp);
}

char *get_outbound(int zone)
{
	char *res;
	ass(domains!=NULL);
	res=ilist_find_entry(domains,zone);
	if(res==NULL)
	{
		res=ilist_find_entry(domains,0);
		if(res==NULL)
		{
			e_printf("unknown zone %d, absent in domains_file %s",zone,domains_file);
			abort2();
		}
		return res;
	}
	return res;
}
